DROP TABLE IF EXISTS #__action_log_config;

CREATE TABLE `#__action_log_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text_prefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__action_log_config VALUES("1","article","com_content.article","id","title","#__content","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("2","article","com_content.form","id","title","#__content","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("3","banner","com_banners.banner","id","name","#__banners","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("4","user_note","com_users.note","id","subject","#__user_notes","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("5","media","com_media.file","","name","","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("6","category","com_categories.category","id","title","#__categories","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("7","menu","com_menus.menu","id","title","#__menu_types","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("8","menu_item","com_menus.item","id","title","#__menu","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("9","newsfeed","com_newsfeeds.newsfeed","id","name","#__newsfeeds","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("10","link","com_redirect.link","id","old_url","#__redirect_links","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("11","tag","com_tags.tag","id","title","#__tags","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("12","style","com_templates.style","id","title","#__template_styles","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("13","plugin","com_plugins.plugin","extension_id","name","#__extensions","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("14","component_config","com_config.component","extension_id","name","","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("15","contact","com_contact.contact","id","name","#__contact_details","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("16","module","com_modules.module","id","title","#__modules","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("17","access_level","com_users.level","id","title","#__viewlevels","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("18","banner_client","com_banners.client","id","name","#__banner_clients","PLG_ACTIONLOG_JOOMLA");
INSERT INTO #__action_log_config VALUES("19","application_config","com_config.application","","name","","PLG_ACTIONLOG_JOOMLA");



DROP TABLE IF EXISTS #__action_logs;

CREATE TABLE `#__action_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__action_logs_extensions;

CREATE TABLE `#__action_logs_extensions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__action_logs_extensions VALUES("1","com_banners");
INSERT INTO #__action_logs_extensions VALUES("2","com_cache");
INSERT INTO #__action_logs_extensions VALUES("3","com_categories");
INSERT INTO #__action_logs_extensions VALUES("4","com_config");
INSERT INTO #__action_logs_extensions VALUES("5","com_contact");
INSERT INTO #__action_logs_extensions VALUES("6","com_content");
INSERT INTO #__action_logs_extensions VALUES("7","com_installer");
INSERT INTO #__action_logs_extensions VALUES("8","com_media");
INSERT INTO #__action_logs_extensions VALUES("9","com_menus");
INSERT INTO #__action_logs_extensions VALUES("10","com_messages");
INSERT INTO #__action_logs_extensions VALUES("11","com_modules");
INSERT INTO #__action_logs_extensions VALUES("12","com_newsfeeds");
INSERT INTO #__action_logs_extensions VALUES("13","com_plugins");
INSERT INTO #__action_logs_extensions VALUES("14","com_redirect");
INSERT INTO #__action_logs_extensions VALUES("15","com_tags");
INSERT INTO #__action_logs_extensions VALUES("16","com_templates");
INSERT INTO #__action_logs_extensions VALUES("17","com_users");



DROP TABLE IF EXISTS #__action_logs_users;

CREATE TABLE `#__action_logs_users` (
  `user_id` int(11) unsigned NOT NULL,
  `notify` tinyint(1) unsigned NOT NULL,
  `extensions` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__assets;

CREATE TABLE `#__assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__assets VALUES("1","0","1","506","0","root.1","Root Asset","{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":[],\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}");
INSERT INTO #__assets VALUES("2","1","1","2","1","com_admin","com_admin","{}");
INSERT INTO #__assets VALUES("3","1","3","6","1","com_banners","com_banners","{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("4","1","7","8","1","com_cache","com_cache","{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}");
INSERT INTO #__assets VALUES("5","1","9","10","1","com_checkin","com_checkin","{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}");
INSERT INTO #__assets VALUES("6","1","11","12","1","com_config","com_config","{}");
INSERT INTO #__assets VALUES("7","1","13","16","1","com_contact","com_contact","{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("8","1","17","84","1","com_content","com_content","{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("9","1","85","86","1","com_cpanel","com_cpanel","{}");
INSERT INTO #__assets VALUES("10","1","87","88","1","com_installer","com_installer","{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1},\"core.delete\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("11","1","89","90","1","com_languages","com_languages","{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("12","1","91","92","1","com_login","com_login","{}");
INSERT INTO #__assets VALUES("13","1","93","94","1","com_mailto","com_mailto","{}");
INSERT INTO #__assets VALUES("14","1","95","96","1","com_massmail","com_massmail","{}");
INSERT INTO #__assets VALUES("15","1","97","98","1","com_media","com_media","{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}");
INSERT INTO #__assets VALUES("16","1","99","100","1","com_menus","com_menus","{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("17","1","101","102","1","com_messages","com_messages","{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}");
INSERT INTO #__assets VALUES("18","1","103","110","1","com_modules","com_modules","{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("19","1","111","114","1","com_newsfeeds","com_newsfeeds","{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("20","1","115","116","1","com_plugins","com_plugins","{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("21","1","117","118","1","com_redirect","com_redirect","{\"core.admin\":{\"7\":1},\"core.manage\":[]}");
INSERT INTO #__assets VALUES("22","1","119","120","1","com_search","com_search","{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}");
INSERT INTO #__assets VALUES("23","1","121","122","1","com_templates","com_templates","{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("24","1","123","124","1","com_users","com_users","{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.own\":{\"6\":1},\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("25","1","125","128","1","com_weblinks","com_weblinks","{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("26","1","129","130","1","com_wrapper","com_wrapper","{}");
INSERT INTO #__assets VALUES("27","8","18","19","2","com_content.category.2","Uncategorised","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("28","3","4","5","2","com_banners.category.3","Uncategorised","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("29","7","14","15","2","com_contact.category.4","Uncategorised","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("30","19","112","113","2","com_newsfeeds.category.5","Uncategorised","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("31","25","126","127","2","com_weblinks.category.6","Uncategorised","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("32","8","20","83","2","com_content.category.7","Demo Content","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("33","32","21","28","3","com_content.category.8","Home Page","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("34","32","29","36","3","com_content.category.9","Extensions","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("35","32","37","60","3","com_content.category.10","Template Features","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("36","32","61","68","3","com_content.category.11","News","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("37","32","69","76","3","com_content.category.12","FAQ","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("38","32","77","82","3","com_content.category.13","Tutorials","{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}");
INSERT INTO #__assets VALUES("39","33","22","23","4","com_content.article.1","Easy Serving Templates","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("40","33","24","25","4","com_content.article.2","Featuring 9 Effects Rotator","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("42","33","26","27","4","com_content.article.4","Our Templates Don\'t Make Conflicts","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("43","34","30","31","4","com_content.article.5","HOT Joomla Carousel","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("44","34","32","33","4","com_content.article.6","HOT Joomla Gallery","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("45","35","38","39","4","com_content.article.7","Font Resizer","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("46","35","40","41","4","com_content.article.8","Typography","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("47","35","42","43","4","com_content.article.9","Hot Menu","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("48","35","44","45","4","com_content.article.10","SEO Friendly","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("49","35","46","47","4","com_content.article.11","Reflection Effect","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("50","35","48","49","4","com_content.article.12","Top Panel","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("51","35","50","51","4","com_content.article.13","Adjustable Widths","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("52","35","52","53","4","com_content.article.14","Lightbox","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("53","35","54","55","4","com_content.article.15","20 Module Positions","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("54","35","56","57","4","com_content.article.16","Five Pre-defined Styles plus Infinite Color Options","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("55","36","62","63","4","com_content.article.17","News Article 1","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("56","36","64","65","4","com_content.article.18","News Article 2","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("57","36","66","67","4","com_content.article.19","News Article 3","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("58","37","70","71","4","com_content.article.20","FAQ Article 1","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("59","37","72","73","4","com_content.article.21","FAQ Article 2","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("60","37","74","75","4","com_content.article.22","FAQ Article 3","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("61","38","78","79","4","com_content.article.23","Regular template installation within Joomla","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("62","38","80","81","4","com_content.article.24","HOT Start Installation","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("63","34","34","35","4","com_content.article.25","HOT Newsflash","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("64","35","58","59","4","com_content.article.26","Five Background Images","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("65","1","484","485","1","com_joomlaupdate","com_joomlaupdate","{\"core.admin\":[],\"core.manage\":[],\"core.delete\":[],\"core.edit.state\":[]}");
INSERT INTO #__assets VALUES("66","1","486","487","1","#__ucm_content.1","#__ucm_content.1","[]");
INSERT INTO #__assets VALUES("67","1","488","489","1","com_finder","com_finder","{}");
INSERT INTO #__assets VALUES("68","1","490","491","1","com_tags","com_tags","{}");
INSERT INTO #__assets VALUES("69","1","492","493","1","com_contenthistory","com_contenthistory","{}");
INSERT INTO #__assets VALUES("70","1","494","495","1","com_ajax","com_ajax","{}");
INSERT INTO #__assets VALUES("71","1","496","497","1","com_postinstall","com_postinstall","{}");
INSERT INTO #__assets VALUES("72","18","104","105","2","com_modules.module.30","Social Icons","{\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"module.edit.frontend\":[]}");
INSERT INTO #__assets VALUES("73","1","498","499","1","com_fields","com_fields","{}");
INSERT INTO #__assets VALUES("74","1","500","501","1","com_associations","com_associations","{}");
INSERT INTO #__assets VALUES("75","18","106","107","2","com_modules.module.36","HOT Joomla Gallery","{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"module.edit.frontend\":[]}");
INSERT INTO #__assets VALUES("76","18","108","109","2","com_modules.module.22","Copyright","{}");
INSERT INTO #__assets VALUES("79","1","502","503","1","com_privacy","com_privacy","{}");
INSERT INTO #__assets VALUES("80","1","504","505","1","com_actionlogs","com_actionlogs","{}");



DROP TABLE IF EXISTS #__associations;

CREATE TABLE `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__banner_clients;

CREATE TABLE `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__banner_tracks;

CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__banners;

CREATE TABLE `#__banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__categories;

CREATE TABLE `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned DEFAULT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__categories VALUES("1","0","0","0","25","0","","system","ROOT","root","","","1","0","0000-00-00 00:00:00","1","{}","","","","647","2009-10-18 16:07:09","0","0000-00-00 00:00:00","0","*","1");
INSERT INTO #__categories VALUES("2","27","1","1","2","1","uncategorised","com_content","Uncategorised","uncategorised","","","1","0","0000-00-00 00:00:00","1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","647","2010-06-28 13:26:37","0","0000-00-00 00:00:00","0","*","1");
INSERT INTO #__categories VALUES("3","28","1","3","4","1","uncategorised","com_banners","Uncategorised","uncategorised","","","1","0","0000-00-00 00:00:00","1","{\"target\":\"\",\"image\":\"\",\"foobar\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","647","2010-06-28 13:27:35","0","0000-00-00 00:00:00","0","*","1");
INSERT INTO #__categories VALUES("4","29","1","5","6","1","uncategorised","com_contact","Uncategorised","uncategorised","","","1","0","0000-00-00 00:00:00","1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","647","2010-06-28 13:27:57","0","0000-00-00 00:00:00","0","*","1");
INSERT INTO #__categories VALUES("5","30","1","7","8","1","uncategorised","com_newsfeeds","Uncategorised","uncategorised","","","1","0","0000-00-00 00:00:00","1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","647","2010-06-28 13:28:15","0","0000-00-00 00:00:00","0","*","1");
INSERT INTO #__categories VALUES("6","31","1","9","10","1","uncategorised","com_weblinks","Uncategorised","uncategorised","","","1","0","0000-00-00 00:00:00","1","{\"target\":\"\",\"image\":\"\"}","","","{\"page_title\":\"\",\"author\":\"\",\"robots\":\"\"}","647","2010-06-28 13:28:33","0","0000-00-00 00:00:00","0","*","1");
INSERT INTO #__categories VALUES("7","32","1","11","24","1","demo-content","com_content","Demo Content","demo-content","","","1","0","0000-00-00 00:00:00","1","{\"category_layout\":\"\",\"image\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","647","2011-01-18 10:58:47","0","0000-00-00 00:00:00","0","*","1");
INSERT INTO #__categories VALUES("8","33","7","12","13","2","demo-content/home-page","com_content","Home Page","home-page","","","1","0","0000-00-00 00:00:00","1","{\"category_layout\":\"\",\"image\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","647","2011-01-18 10:59:16","0","0000-00-00 00:00:00","0","*","1");
INSERT INTO #__categories VALUES("9","34","7","14","15","2","demo-content/extensions","com_content","Extensions","extensions","","","1","0","0000-00-00 00:00:00","1","{\"category_layout\":\"\",\"image\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","647","2011-01-18 10:59:30","0","0000-00-00 00:00:00","0","*","1");
INSERT INTO #__categories VALUES("10","35","7","16","17","2","demo-content/template-features","com_content","Template Features","template-features","","","1","0","0000-00-00 00:00:00","1","{\"category_layout\":\"\",\"image\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","647","2011-01-18 10:59:39","0","0000-00-00 00:00:00","0","*","1");
INSERT INTO #__categories VALUES("11","36","7","18","19","2","demo-content/news","com_content","News","news","","","1","0","0000-00-00 00:00:00","1","{\"category_layout\":\"\",\"image\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","647","2011-01-18 10:59:50","0","0000-00-00 00:00:00","2","*","1");
INSERT INTO #__categories VALUES("12","37","7","20","21","2","demo-content/faq","com_content","FAQ","faq","","","1","0","0000-00-00 00:00:00","1","{\"category_layout\":\"\",\"image\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","647","2011-01-18 10:59:58","0","0000-00-00 00:00:00","1","*","1");
INSERT INTO #__categories VALUES("13","38","7","22","23","2","demo-content/tutorials","com_content","Tutorials","tutorials","","","1","0","0000-00-00 00:00:00","1","{\"category_layout\":\"\",\"image\":\"\"}","","","{\"author\":\"\",\"robots\":\"\"}","647","2011-01-18 11:00:10","0","0000-00-00 00:00:00","0","*","1");



DROP TABLE IF EXISTS #__contact_details;

CREATE TABLE `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned DEFAULT NULL,
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__contact_details VALUES("1","Hot Joomla Templates","hot-joomla-templates","Template Club","Address 17th","City Name","State","USA","92630","5555551212","5555551212","","images/powered_by.png","noreply@coffeinetemplate.com","0","1","0","0000-00-00 00:00:00","1","{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}","0","4","1","5555551212","#","","","","*","2011-01-18 11:30:31","647","","0000-00-00 00:00:00","0","","","{\"robots\":\"\",\"rights\":\"\"}","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","1","6");



DROP TABLE IF EXISTS #__content;

CREATE TABLE `#__content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__content VALUES("1","39","Easy Serving Templates","easy-serving-templates","<p><strong>Hot Coffeine</strong> is <strong>Joomla template</strong> with smell of <strong>coffee</strong>! If you like to drink <strong>espresso</strong>, you probably know how complicated it could be to prepare it. <strong>Coffee companies</strong> often use term &quot;Easy Serving Espresso&quot; for new methods of making a delicious cup of espresso at home, with ease. With Joomla templates from HotJoomlaTemplates.com you can &quot;prepare&quot; your eye-catching website in less than hour. That\'s why we are calling our templates &quot;<strong>Easy Serving Templates</strong>&quot;.</p>
\n<p>Target users of this template are <strong>coffee companies</strong>, <strong>cafe bars</strong>, <strong>restaurants</strong>, <strong>internet cafes</strong>, <strong>coffee resellers</strong>. But, with 5 pre-defined styles and infinite color selections, you can use it for any other purpose.</p>
\n","
\n<p><strong>Hot Coffeine</strong> is <strong>Joomla template</strong> with smell of <strong>coffee</strong>! If you like to drink <strong>espresso</strong>, you probably know how complicated it could be to prepare it. <strong>Coffee companies</strong> often use term &quot;Easy Serving Espresso&quot; for new methods of making a delicious cup of espresso at home, with ease. With Joomla templates from HotJoomlaTemplates.com you can &quot;prepare&quot; your eye-catching website in less than hour. That\'s why we are calling our templates &quot;<strong>Easy Serving Templates</strong>&quot;.</p>
\n<p>Target users of this template are <strong>coffee companies</strong>, <strong>cafe bars</strong>, <strong>restaurants</strong>, <strong>internet cafes</strong>, <strong>coffee resellers</strong>. But, with 5 pre-defined styles and infinite color selections, you can use it for any other purpose.</p>
\n<ul>
\n  <li>100% tableless CSS code</li>
\n  <li>Validates with XHTML 1.0 Transitional</li>
\n  <li>Validates with CSS Level 2.1</li>
\n  <li>HOT Effects Slider included with template (module is not available for free download)</li>
\n  <li>HOT Joomla Carousel and HOT Joomla Gallery   extensions pre-installed</li>
\n  <li>Custom page width and left/right columns widths</li>
\n  <li>Five pre-defined template styles. Unlimited colors via template parameters, choose your template   colors with ease</li>
\n  <li>Lightbox, Reflection, Font Resizer and Top Panel features enabled</li>
\n  <li>4 Menu effects: Fade, Scroll Down, Drop-In, None</li>
\n  <li>HOT Start (SQL dump) available with each purchase (single or membership)</li>
\n  <li>SEO friendly</li>
\n  <li>PSDs included</li>
\n  <li>20 module positions fully collapsible module positions</li>
\n  <li>Tested with IE7+, Firefox 3+, Chrome, Safari, Opera</li>
\n</ul>","1","8","2011-01-18 11:01:13","647","","2011-01-29 14:46:42","42","0","0000-00-00 00:00:00","2011-01-18 11:01:13","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","3","1","","","1","23","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","1","*","","");
INSERT INTO #__content VALUES("2","40","Featuring 9 Effects Rotator","featuring-9-effects-rotator","<p>Brand new module <strong>HOT Effects Rotator</strong> is included with this template. It\'s simple, yet powerful <strong>image slideshow module</strong>. This module makes slideshow presentations with selection of 9 <strong>transition effects</strong>. It\'s fully configurable, simple image rotator, based on jQuery 1.4. In module parameters, you have control over module display. You can   change width, height, and select effects parameters. It\'s possible to add internal or external <strong>link</strong> for each image in rotation. Also, if you like, you can write <strong>description text</strong> for any image in rotation.</p>","","1","8","2011-01-18 11:01:31","647","","2011-01-29 20:30:25","42","0","0000-00-00 00:00:00","2011-01-18 11:01:31","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","8","0","","","1","19","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","1","*","","");
INSERT INTO #__content VALUES("4","42","Our Templates Don\'t Make Conflicts","our-templates-dont-make-conflicts","<p><a href=\"http://www.jquery.com\" target=\"_blank\"><img src=\"images/stories/demo/noConflict.gif\" width=\"267\" height=\"178\" alt=\"jquery noConflict\" style=\"float:left; margin-right:15px\" class=\"reflect ropacity15\" />jQuery</a> is powerful javascript library. Almost all of our extensions are based on that library (Top Menu, HOT Image Slider, HOT Newsflash, HOT Joomla Gallery, HOT Joomla Carousel, Lightbox, Font resizer, more are coming...). However, many Joomla extensions from other providers use other libraries (<a href=\"http://www.mootools.net\">mooTools</a> or <a href=\"http://www.prototypejs.org\">prototype</a>).</p>
\n<p>Using them together on a page will probably make conflicts. As a result, some or all of your extensions would not work.</p>
\n<p>However, we have found a solution. Our Joomla extensions use &quot;jQuery noConflict mode&quot;. Therefore, with our templates, beside our extensions, you can also use other extensions from other providers based on other javascript libraries.</p>","","1","8","2011-01-18 11:02:06","647","","2011-01-18 12:39:29","42","0","0000-00-00 00:00:00","2011-01-18 11:02:06","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","2","0","","","1","4","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("5","43","HOT Joomla Carousel","hot-joomla-carousel","<p><img class=\"reflect rheight15\" src=\"images/stories/demo/hot_joomla_carousel.png\" border=\"0\" alt=\"hot joomla carousel\" width=\"326\" height=\"150\" style=\"margin-left: 15px; float: right;\" />Need to display your images as a carousel? Easily done with our new Joomla extension.</p>
\n<p>HOT Joomla Carousel is a simple Joomla module that will help you to show your photos in a carousel style. You can see how it works on this demo site. Usage is very simple. You need to enter path to your images and your carousel is ready.</p>
\n<h3>USAGE INSTRUCTIONS</h3>
\n<p>Open module parameters in Extensions &gt; Module Manager &gt; HOT Joomla Carousel. You\'ll see that some default parameters are already there. However, you should change some of them to accommodate module for usage on your site.</p>
\n<ul>
\n<li>LOAD JQUERY: Select whether to load jQuery library or not. If your template already loads it, you may disable this to avoid possible javascript errors.</li>
\n<li>FOLDER: Where your images are stored, relative to Joomla root directory.</li>
\n<li>OVERALL WIDTH OF MODULE: Overall width of module in pixels (in example 200)</li>
\n<li>OVERALL WIDTH OF MODULE: Overall height of module in pixels (in example 150)</li>
\n<li>NUMBER OF IMAGES ON SCREEN: Number of images that will be shown on screen at the same time (in example 5)</li>
\n<li>WIDTH OF IMAGES: Width of images in carousel in pixels (in example 128)</li>
\n<li>HEIGHT OF IMAGES: Height of images in carousel in pixels (in example 128)</li>
\n<li>MARGIN BETWEEN TWO IMAGES: Distance between two neighbor images in pixels (in example 10)</li>
\n<li>PADDING BETWEEN BORDER AND IMAGE: Padding between image borders and images in pixels (in example 2)</li>
\n<li>BORDER WIDTH: Width of borders of images in pixels (in example 2)</li>
\n<li>BORDER COLOR: Color of borders of images in hexadecimal format (in example 000000)</li>
\n<li>SHOW PAGINATION: Select whether to display linked numbers of carousel pages or not</li>
\n<li>AUTOSLIDE: Select whether to change images automatically or not</li>
\n<li>AUTOSLIDE INTERVAL: Time in milliseconds between change of slides (only if autoslide enabled)</li>
\n<li>SELECT TRANSITION EFFECT: Select slide or fade transition effect</li>
\n<li>ANIMATION SPEED: Select speed of transition animation</li>
\n<li>DIRECTION OF IMAGES: Select horizontal to display images in a row, or select vertical to display images in a column</li>
\n<li>TRANSITION LOOP: Select whether to show transition of images in loop or not</li>
\n</ul>
\n<p> </p>","","1","9","2011-01-18 11:02:28","647","","2012-03-19 15:18:33","42","0","0000-00-00 00:00:00","2011-01-18 11:02:28","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}","2","2","","","1","41","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("6","44","HOT Joomla Gallery","hot-joomla-gallery","<p><img src=\"images/stories/demo/hot_joomla_gallery.png\" alt=\"hot joomla gallery\" width=\"300\" height=\"146\" style=\"margin-left:15px; float:right\" class=\"reflect\" />Our new extension HOT Joomla Gallery is incorporated in this template.  You can see how it works on this demo site. Usage is very simple. You  need to enter path to your images and your gallery is ready. Control  other parameters to make your gallery works better with your theme.</p>
\n<p>The \"HOT Joomla Gallery\" module by HotJoomlaTemplates.com is a fully configurable, simple gallery module, based on jQuery.</p>
\n<p>In module parameters, you have control over module display. You can enable or disable image descriptions. It\'s possible to change number of thumbnails. Images can be shown in &quot;per name&quot; or random order. Slide duration is configurable as well. Module colors are configurable. Unlike our other extensions, here you can\'t change module width and height. Module width and height are set automatically, based on resolutions of your images. So, please prepare images in a folder before publishing this module.</p>
\n<h3>USAGE INSTRUCTIONS</h3>
\n<p>Open module parameters in Extensions &gt; Module Manager &gt; HOT Joomla Gallery. You\'ll see that some default parameters are already there. However, you should change some of them to accomodate module for usage on your site.</p>
\n<ul>
\n  <li>LOAD JQUERY: Select wheter to load jQuery library or not. If your template already loads it, you may disable this to avoid possible javascript errors.</li>
\n  <li>FOLDER: Where your images are stored, relative to Joomla root directory.</li>
\n  <li>ENTER DATA: Fill this only if you need photos with description text. Otherwise, leave this empty and photos will be shown without description.</li>
\n  <li>SHUFFLE IMAGES: Select whether to randomize images order or not.</li>
\n  <li>TIMER: How long one photo will stay on screen. Time is in milliseconds.</li>
\n  <li>AUTO-SLIDE: Select whether to rotate photos automatically or not.</li>
\n  <li>GALLERY COLOR: Enter module\'s border color.</li>
\n  <li>ACTIVE THUMBNAIL BORDER: Border color of active thumbnail image.</li>
\n  <li>DESCRIPTION TEXT BACKGROUND COLOR: Self explanory.</li>
\n  <li>DESCRIPTION TEXT COLOR: Self explanory.</li>
\n</ul>
\n<p>&nbsp;</p>","","1","9","2011-01-18 11:02:47","647","","0000-00-00 00:00:00","0","0","0000-00-00 00:00:00","2011-01-18 11:02:47","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","1","","","1","53","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("7","45","Font Resizer","font-resizer","<p><img src=\"images/stories/demo/font_resizer.png\" width=\"256\" height=\"232\" alt=\"font resize\" style=\"float:left; margin-right:15px\" />jQuery based Font re-size feature with cookie that keeps visitor\'s selection. Loading of this feature can be disabled in template parameters, if you don\'t need it. The font re-sizer has three buttons: smaller font, reset font and larger font. In this demo, it\'s located in footer area. You can test it, and as you can see, it will remember your selection while you browsing this demo site.</p>
\n<p>It\'s a dynamic script, so it doesn\'t use separate CSS stylesheets for smaller or larger fonts. There is no page reloading needed to change font size.</p>","","1","10","2011-01-18 11:03:16","647","","0000-00-00 00:00:00","0","0","0000-00-00 00:00:00","2011-01-18 11:03:16","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","10","","","1","5","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("8","46","Typography","typography","<p><strong>This page represents typographical aspects of the \"Skies\" template. Take care about your typography to make better user experience for your readers. How to achieve that?</strong></p>
\n<ul>
\n<li>Learn more about typography, escpecially about the most often used codes, such as <a href=\"http://www.w3schools.com/TAGS/tag_p.asp\" target=\"_blank\">&lt;p&gt;</a>, <a href=\"http://www.w3schools.com/TAGS/tag_hn.asp\" target=\"_blank\">&lt;h1&gt;</a>, <a href=\"http://www.w3schools.com/TAGS/tag_hn.asp\" target=\"_blank\">&lt;h2&gt;</a>, <a href=\"http://www.w3schools.com/TAGS/tag_hn.asp\" target=\"_blank\">&lt;h3&gt;</a>, <a href=\"http://www.w3schools.com/tags/tag_IMG.asp\" target=\"_blank\">&lt;img&gt;</a> and <a href=\"http://www.w3schools.com/TAGS/tag_a.asp\" target=\"_blank\">&lt;a&gt;</a>.</li>
\n<li>This template has valid XHTML, but if you want to keep it like that, you must learn and follow the XHTML principles. Also, if some of your extensions are not XHTML valid, pages based on this component would not be XHTML valid as well (no matter if template itself is valid).</li>
\n<li>Familiarize yourself with CSS styles that comes with this template.</li>
\n<li>Never copy/paste directly from layout text editors, such as Microsoft Word or OpenOffice. Try to paste text in plain editors first (such as Notepad).</li>
\n<li>Use a WYSIWYG editor that comes with Joomla or install a better editor, but always check your code in the editor\'s HTML mode.</li>
\n</ul>
\n<p class=\"quote\">My mother said to me, \"If you are a soldier, you will become a general. If you are a monk, you will become the Pope.\" Instead, I was a painter, and became Picasso... To have a quote styled like that use \"quote\" class with paragraph of text, like in this sample code: &lt;p class=\"quote\"&gt;...your text here...&lt;/p&gt;</p>
\n<h1>Heading One</h1>
\n<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>
\n<h2>Heading Two</h2>
\n<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>
\n<h3>Heading Three</h3>
\n<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>
\n<h4>Heading Four</h4>
\n<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis at vero eros et accumsan et iusto odio dignissim qui blandit praesent luptatum zzril delenit augue duis dolore te feugait nulla facilisi.</p>
\n<p class=\"warning\">This is <strong>a warning message</strong> you may use in your text. Simply add appropriate class to your paragraphs to achieve this effect. Here\'s a sample code: &lt;p class=\"warning\"&gt;...your text here...&lt;/p&gt;. The rest of text is just filler. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat.</p>
\n<p class=\"info\">This is <strong>an information message</strong> you may use in your text. Simply add appropriate class to your paragraphs to achieve this effect. Here\'s a sample code: &lt;p class=\"info\"&gt;...your text here...&lt;/p&gt;. The rest of text is just filler. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat.</p>
\n<p class=\"error\">This is <strong>an error message</strong> you may use in your text. Simply add appropriate class to your paragraphs to achieve this effect. Here\'s a sample code: &lt;p class=\"error\"&gt;...your text here...&lt;/p&gt;. The rest of text is just filler. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat.</p>
\n<p class=\"code\">This is <strong>code style</strong> you may use in your text. Simply add appropriate class to your paragraphs to achieve this effect. Here\'s a sample code: &lt;p class=\"code\"&gt;...your text here...&lt;/p&gt;. The rest of text is just filler. Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat.</p>
\n<h4>Unordered list sample:</h4>
\n<ul>
\n<li>list element one</li>
\n<li>list element two           
\n<ul>
\n<li>list subelement one</li>
\n<li>list subelement two</li>
\n<li>list subelement three</li>
\n</ul>
\n</li>
\n<li>list element three</li>
\n<li>list element four</li>
\n</ul>
\n<h4>Ordered list sample:</h4>
\n<ol>
\n<li>list element one</li>
\n<li>list element two<ol>
\n<li>list subelement one</li>
\n<li>list subelement two</li>
\n<li>list subelement three</li>
\n</ol></li>
\n<li>list element three</li>
\n<li>list element four</li>
\n</ol>
\n<h4>Check list sample:</h4>
\n<ul class=\"checklist\">
\n<li>to achieve this effect</li>
\n<li>add class \"checklist\" to your unordered list</li>
\n<li>like &lt;ul class=\"checklist\"&gt;</li>
\n</ul>
\n<h4>Arrow list sample:</h4>
\n<ul class=\"arrow\">
\n<li>to achieve this effect</li>
\n<li>add class \"arrow\" to your unordered list</li>
\n<li>like &lt;ul class=\"arrow\"&gt;</li>
\n</ul>
\n<h4>Star list sample:</h4>
\n<ul class=\"star\">
\n<li>to achieve this effect</li>
\n<li>add class \"star\" to your unordered list</li>
\n<li>like &lt;ul class=\"star\"&gt;</li>
\n</ul>","","1","10","2011-01-18 11:03:28","647","","0000-00-00 00:00:00","0","0","0000-00-00 00:00:00","2011-01-18 11:03:28","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","9","","","1","43","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("9","47","Hot Menu","hot-menu","<p>This template has a fast-loading jQuery based top menu with nested sub-menus. Sub-menu opens with a nice animation effect. Core Joomla files are not hacked. Module position User3 is reserved for the top menu. Please type \"nav\" in Menu Tag ID. Menu type should be set to \"list\".</p>
\n<p>The vertical menu placed to the left hand side column here is classic static Joomla menu with support for sub-menu items. You don\'t have to change default menu parameters for this menu. Menu type should be set to \"list\". You don\'t need to type anything in Menu Tag ID, Menu Class Suffix or Module Class Suffix fields.</p>
\n<p><strong>This information is not important if you are installing template using our HOT Start package. In this case, all parameters are set.</strong></p>","","1","10","2011-01-18 11:03:46","647","","2011-01-20 08:20:58","42","0","0000-00-00 00:00:00","2011-01-18 11:03:46","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","2","8","","","1","21","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("10","48","SEO Friendly","seo-friendly","<p><img src=\"images/stories/demo/seo-optimized.jpg\" alt=\"seo optimized\" width=\"250\" height=\"190\" style=\"margin:10px 10px 10px 15px; float:right\" class=\"reflect rheight35 ropacity40\" /><strong>You don\'t need a nice website if Google can\'t index it and position it higher in search results.</strong></p>
\n<p>Even SEO beginners know that <strong>H1</strong> and <strong>H2</strong> tags are important and that  Google spiders look for them when indexing your page. Joomla itself  doesn\'t put headings in <strong>H1</strong> and <strong>H2</strong>. <strong>With this template, it does!</strong></p>
\n<p>This feature is automatically enabled in the template. You can check HTML code of the demo home page. You will see that big heading is in &lt;H1&gt; tag, while sub-heading is in &lt;H2&gt; tag. Without this template, these headings are in default <strong>componentheading</strong> and <strong>contentheading</strong> Joomla classes. Important note is that Joomla core files are NOT hacked, so you won\'t have any problems with upgrading, when new version of Joomla is available.</p>","","1","10","2011-01-18 11:04:01","647","","0000-00-00 00:00:00","0","0","0000-00-00 00:00:00","2011-01-18 11:04:01","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","7","","","1","14","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("11","49","Reflection Effect","reflection-effect","<p><strong>We integrated reflection script with this template. So, you can add reflection to your images without editing them in Photoshop.</strong></p>
\n<p>Beside that, you have full control over the reflection height and opacity.</p>
\n<h3>How to add reflection effect to the picture</h3>
\n<p><img class=\"reflect ropacity60 rheight25\" src=\"images/stories/demo/reflection.jpg\" alt=\"reflection effect\" width=\"200\" height=\"200\" style=\"float:left; margin-right:15px\" />Add class=&quot;reflect&quot; to any image you\'d like to have reflection effect, and you are done!</p>
\n<p>To control the effect\'s <strong>height</strong>, use class=&quot;reflect rheight25&quot;. In this case, height of the reflection will be 25% of the image height. You can also, control <strong>opacity</strong> of the reflection. Use  class=&quot;reflect ropacity60&quot; and opacity will be set to 60%. You can also combine height and opacity, in example class=&quot;reflect rheight25 ropacity60&quot;.</p>
\n<p>&nbsp;</p>
\n<p>&nbsp;</p>
\n<p>&nbsp;</p>
\n<p>&nbsp;</p>
\n<p class=\"code\">&lt;img class=&quot;reflect ropacity60 rheight25&quot; src=&quot;images/stories/demo/reflection.jpg&quot; alt=\"reflection effect\"&gt;</p>","","1","10","2011-01-18 11:04:14","647","","0000-00-00 00:00:00","0","0","0000-00-00 00:00:00","2011-01-18 11:04:14","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","6","","","1","8","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("12","50","Top Panel","top-panel","<p><img src=\"images/stories/demo/panel.png\" alt=\"top panel\" style=\"margin-left:15px; float:right\" class=\"reflect rheight35 ropacity40\" />Imagine this situation: You have many modules to publish, but if you publish them all, your web site would become too busy. With this feature, you can have  some modules published, but hidden into the top panel. When visitor needs some of these modules, he  clicks  the OPEN button and the top panel will slide down. Once he\'s done, he  clicks theCLOSE button and the top panel will be hidden again.</p>
\n <p>The top panel contains four module positions. Those positions and floatable and have fluid width. In template parameters, you can change the panel\'s background color, as well as font color.</p>","","1","10","2011-01-18 11:04:26","647","","0000-00-00 00:00:00","0","0","0000-00-00 00:00:00","2011-01-18 11:04:26","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","5","","","1","5","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("13","51","Adjustable Widths","adjustable-widths","<p>You can define overall template width as well as widths of the left hand side and the right hand side columns with modules. All of this is done very easily in the template configuration. Main content area will be calculated to fit best between the left hand side and the right hand side column, no matter what values you entered for them. Also, if you don\'t have left or right modules published on certain pages, main content area will occupy their space.</p>
\n<p align=\"center\"><img src=\"images/stories/demo/custom_width.jpg\" alt=\"widths\" /></p>","","1","10","2011-01-18 11:04:42","647","","0000-00-00 00:00:00","0","0","0000-00-00 00:00:00","2011-01-18 11:04:42","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","4","","","1","6","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("14","52","Lightbox","lightbox","<p>If you like effect used on the images on this Demo site, you can use it for your site. This template comes with integrated jQuery Lightbox. Please prepare thumbnail image(s) and full size image(s) before proceeding.
\n</p>
\n<p>To test how Lightbox gallery works, please check Color Schemes page and click on the pictures.</p>
\n<h3>Single Image Lightbox</h3>
\n<p>If you don\'t know HTML, you can use built-in Joomla editor. What you need to do:</p>
\n<ol>
\n  <li>Create a new paragraph and assign &quot;gallery&quot; ID to it</li>
\n  <li>Insert thumbnail image inside</li>
\n  <li>Link the  thumbnail image with full-size image</li>
\n  <li>You are done!</li>
\n</ol>
\n<p>HTML view should look close to this example:</p>
\n<p class=\"code\">&lt;p id=&quot;gallery&quot; align=&quot;center&quot;&gt;<br /> 
\n  &lt;a href=&quot;images/stories/sample.jpg&quot; title=&quot;This is module positions layout.&quot;&gt;<br /> 
\n  &lt;img src=&quot;images/stories/sample_small.jpg&quot; border=&quot;0&quot; width=&quot;200&quot; height=&quot;152&quot; /&gt;<br /> &lt;/a&gt;<br />&lt;/p&gt;</p>
\n<h3>Multiple Images Lightbox</h3>
\n<p>Here\'s what you need to do to make a mini gallery, using Joomla editor:</p>
\n<ol>
\n  
\n  <li>Create a new paragraph and assign &quot;gallery&quot; ID to it</li>
\n  <li>Make an unordered list </li>
\n  <li>Insert thumbnail image inside every list element</li>
\n  <li>Link each thumbnail image with full-size image</li>
\n  <li>You are done!</li>
\n</ol>
\n<p>HTML view should look close to this example:</p>
\n<p class=\"code\">&lt;p id=&quot;gallery&quot;&gt;<br /><br />
\n  &lt;ul&gt;<br /><br />
\n  &lt;li&gt;&lt;a href=&quot;images/stories/sample1.jpg&quot; title=&quot;Step 2&quot;&gt;&lt;img src=&quot;images/stories/sample_small1.jpg&quot; border=&quot;0&quot; width=&quot;136&quot; height=&quot;100&quot; /&gt;&lt;/a&gt;&lt;/li&gt;<br /><br />
\n  &lt;li&gt;&lt;a href=&quot;images/stories/sample2.jpg&quot; title=&quot;Step 3&quot;&gt;&lt;img src=&quot;images/stories/sample_small2.jpg&quot; border=&quot;0&quot; width=&quot;120&quot; height=&quot;100&quot; /&gt;&lt;/a&gt;&lt;/li&gt;<br /><br />&lt;/ul&gt;<br /><br />
\n&lt;/p&gt;</p>","","1","10","2011-01-18 11:04:53","647","","2011-01-20 08:19:26","42","0","0000-00-00 00:00:00","2011-01-18 11:04:53","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","2","3","","","1","14","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("15","53","20 Module Positions","20-module-positions","<p align=\"center\"><img src=\"images/stories/demo/module_positions.jpg\" alt=\"module positions\" /></p>
\n<p>This template has support for 20 module positions. All module positions are collapsible. If no modules are published on some module positions, those module positions will automatically collapse.</p>","","1","10","2011-01-18 11:05:09","647","","2011-01-29 16:21:10","42","0","0000-00-00 00:00:00","2011-01-18 11:05:09","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","2","2","","","1","50","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("16","54","Five Pre-defined Styles plus Infinite Color Options","five-pre-defined-styles-plus-infinite-color-options","<p><strong><img src=\"images/stories/demo/template_parameters.jpg\" alt=\"parameters\" width=\"350\" height=\"334\" align=\"left\" style=\"margin-right:15px\" />Unlimited color options!</strong> Select your own colors. This is useful if you want to match main template color with your company logo.</p>
\n<p><strong>Five pre-defined styles  available.</strong> There are three variants of top background image (home page). Whatever color you select for themain template color, all background images will be updated accordingly. </p>
\n<p>&nbsp;</p>
\n<p><strong>With our templates, you don\'t need to edit images in Photoshop.</strong></p>
\n<p>To get to the parameters in your Joomla Admin go to: Extensions &gt; Template Manager and select HOT Coffeine. There you can select colors and background images.  The template colors can be selected from handy palette  tool or entered manually  in hexadecimal format (combination of 6 letters and numbers). If you don\'t have Photoshop, Fireworks or similar application, <a href=\"http://www.colorcombos.com\" title=\"Color Shemes\">Color Combos</a> can help you to find out the hexadecimal code of your color.</p>
\n<p>&nbsp;</p>
\n<p>&nbsp;</p>
\n<p>&nbsp;</p>
\n<p class=\"quote\">Change few options in template parameters and... Boom! You got template with completely new experience!</p>","","1","10","2011-01-18 11:05:21","647","","2011-01-29 17:34:31","42","0","0000-00-00 00:00:00","2011-01-18 11:05:21","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","4","1","","","1","16","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("17","55","News Article 1","news-article-1","<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</p>
\n","
\n<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.</p>","1","11","2011-01-18 11:05:50","647","","0000-00-00 00:00:00","0","0","0000-00-00 00:00:00","2011-01-18 11:05:50","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","2","","","1","23","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("18","56","News Article 2","news-article-2","<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</p>
\n","
\n<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.</p>","1","11","2011-01-18 11:06:04","647","","0000-00-00 00:00:00","0","0","0000-00-00 00:00:00","2011-01-18 11:06:04","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","1","","","1","21","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("19","57","News Article 3","news-article-3","<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</p>
\n","
\n<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.</p>","1","11","2011-01-18 11:06:16","647","","0000-00-00 00:00:00","0","0","0000-00-00 00:00:00","2011-01-18 11:06:16","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","0","","","1","39","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("20","58","FAQ Article 1","faq-article-1","<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</p>
\n","
\n<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.</p>","1","12","2011-01-18 11:06:41","647","","2013-05-10 11:33:40","42","0","0000-00-00 00:00:00","2011-01-18 11:06:41","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}","2","2","","","1","41","{\"tags\":[2,3],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("21","59","FAQ Article 2","faq-article-2","<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</p>
\n","
\n<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.</p>","1","12","2011-01-18 11:06:52","647","","0000-00-00 00:00:00","0","0","0000-00-00 00:00:00","2011-01-18 11:06:52","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","1","","","1","46","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("22","60","FAQ Article 3","faq-article-3","<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</p>
\n","
\n<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, At accusam aliquyam diam diam dolore dolores duo eirmod eos erat, et nonumy sed tempor et et invidunt justo labore Stet clita ea et gubergren, kasd magna no rebum. sanctus sea sed takimata ut vero voluptua. est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat.</p>","1","12","2011-01-18 11:07:06","647","","0000-00-00 00:00:00","0","0","0000-00-00 00:00:00","2011-01-18 11:07:06","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","0","","","1","93","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("23","61","Regular template installation within Joomla","regular-template-installation-within-joomla","<ol>
\n<li>Unzip file \"hot_coffeine1x.zip\" from archive you downloaded after purchase.</li>
\n<li>In your Joomla admin panel, go Extensions &gt; Extension Manager. <em>See Image 1.</em></li>
\n<li>Click &lt;Browse&gt; button and locate file \"hot_coffeine1x.zip\" on your computer. Click &lt;Upload &amp; Install&gt; button. <em>See Step Image 2.</em></li>
\n<li>Once the file has been uploaded on your server, you would get a message as on this image. <em>See Image 3.</em></li>
\n<li>Go Extensions &gt; Template Manager, select \"hot_coffeine - Default\" from the list and click Default icon (star in the right column). <em>See Image 4.</em></li>
\n<li>Check site frontend. Now you should see your website with a new template.</li>
\n<li>You need to type \"nav\" in Menu Tag ID of the top menu module (position User3). Menu Class Suffix should be empty. Menu style should be set to \"list\".</li>
\n</ol>
\n<div id=\"gallery\">
\n<ul>
\n<li> <a href=\"images/stories/demo/tutorial/regular_image1.jpg\" title=\"Image 1\"> <img src=\"images/stories/demo/tutorial/regular_image1_s.jpg\" border=\"0\" width=\"136\" height=\"100\" /> </a> </li>
\n<li> <a href=\"images/stories/demo/tutorial/regular_image2.jpg\" title=\"Image 2\"> <img src=\"images/stories/demo/tutorial/regular_image2_s.jpg\" border=\"0\" width=\"120\" height=\"100\" /> </a> </li>
\n<li> <a href=\"images/stories/demo/tutorial/regular_image3.jpg\" title=\"Image 3\"> <img src=\"images/stories/demo/tutorial/regular_image3_s.jpg\" border=\"0\" width=\"109\" height=\"100\" /> </a> </li>
\n<li> <a href=\"images/stories/demo/tutorial/regular_image4.jpg\" title=\"Image 4\"> <img src=\"images/stories/demo/tutorial/regular_image4_s.jpg\" border=\"0\" width=\"142\" height=\"100\" /> </a> </li>
\n</ul>
\n</div>
\n<p>After the installation procedure, you won\'t get your website look as this Demo. Maybe you\'d need to change positions of your modules according to <a href=\"index.php?option=com_content&view=article&id=15&Itemid=104\" title=\"Module Positions\">this guide</a> and change parameters in some of your menus.</p>
\n<p>If you like effects used on above images, you can use it for your site. This template comes with integrated jQuery Lightbox. Please read details how to use it.</p>","","1","13","2011-01-18 11:07:31","647","","2011-08-04 08:42:55","42","0","0000-00-00 00:00:00","2011-01-18 11:07:31","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","6","1","","","1","56","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("24","62","HOT Start Installation","hot-start-installation","<p>Once you finish this installation method, you should get exactly the  same copy of this Demo site on your server. Let\'s start!</p>
\n<ol>
\n<li>Unzip file \"hot_coffeine1x_hotstart.zip\" from the archive you  downloaded after purchase. Unzip this archive to your computer.</li>
\n<li>Using FTP software (such as <a href=\"http://filezilla-project.org/\" target=\"_blank\">FileZilla</a>) upload all files and folders to your  hosting space. Make sure that folder where you uploaded files is writable by server (chmod 755 or 777).</li>
\n<li>In browser, open address  http://www.your_site_address.com/joomla/index.php (change \"your_site_address.com\" with your site address, change \"joomla\" with folder name where you uploaded files, if you uploaded files to the root folder, you don\'t need this).</li>
\n<li>Select your language and click Next.</li>
\n<li>The installer will check your server to find out if it\'s compatible  with Joomla. If you see any parts marked red, please contact your  hosting provider to resolve the problem. If all items are green, you can  click Next.</li>
\n<li>You can read Joomla License and click Next.</li>
\n<li>You should enter MySQL database connection parameters now. Please enter Host Name (usually \"localhost\"), username, password and database name and click Next. If you get error message, please check database parameters. If you don\'t know correct parameters, please contact your hosting provider.</li>
\n<li>On FTP Configuration page, you can enter parameters of your FTP  server. This is not necessary and can be entered later, if needed. So, just click Next.</li>
\n<li>On Main Configuration screen you should enter Site Name, e-mail and  administrator\'s username and password (twice). <strong>Click Install Sample Data button.</strong> (Otherwise, demo content won\'t be imported). Once you  get \"Sample data installed successfully\" message, you may click Next.</li>
\n<li>As the Finish screen says, please remove  \"installation\" folder from your server (use FTP software).</li>
\n<li>Congratulations, you are done! Click Site button to see your site\'s  frontend, or Admin to see site\'s backend (login required with username and password that you selected during installation).</li>
\n</ol>","","1","13","2011-01-18 11:07:43","647","","2011-08-04 08:42:44","42","0","0000-00-00 00:00:00","2011-01-18 11:07:43","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","5","0","","","1","53","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("25","63","HOT Newsflash","hot-newsflash","<p>Do you need some articles of your website to stand out of the others?  Here it comes our fully configurable, featured articles rotator, based  on jQuery. In module parameters, you have control over module display.  You can change module width, height, border, all colors. You can add  internal or external link to each image in rotation. So, don\'t have to  mention only articles from your site.</p>
\n<h3>USAGE INSTRUCTIONS</h3>
\n<p>Open module parameters in Extensions &gt; Module Manager &gt; HOT Newsflash. You\'ll see that some default parameters are already there. However, you should change some of them to accomodate module for usage on your site.</p>
\n<ul>
\n  <li>LOAD JQUERY: Select wheter to load jQuery library or not. If  your template already loads it, you may disable this to avoid possible  javascript errors.</li>
\n  <li>MODULE WIDTH: Overall module width. If you  have border, overall width will be higher for border width (x2). Height  of the module depends of images height (set this below).</li>
\n  <li> BACKGROUND  COLOR: Background color of the text area in hexadecimal format (in example ffffff). You may use <a href=\"http://meyerweb.com/eric/tools/color-blend/\" target=\"_blank\">Color Blender</a> to get values if you don\'t have software, such as Photoshop.</li>
\n  <li>BORDER WIDTH: Border width is numerical value in pixels. Type only number (in example 3).</li>
\n  <li>BORDER COLOR: Color of the border line  in hexadecimal format (in example 000000).</li>
\n  <li>NUMBER OF ARTICLES: How many featured articles you\'d like to show. Select number 1-5.</li>
\n  <li>DISPLAY READ MORE LINKS: Enable/disable \"read more\" links. They are not necessary as articles\' headers are linked.</li>
\n  <li>READ MORE LINK TEXT: Text for \"read more\" links (if they are enabled above).</li>
\n  <li>TABS WIDTH: Width of the tabs that are used to rotate between articled. Height of the tabs are calculated automatically.</li>
\n  <li>TABS BACKGROUND  COLOR (REGULAR, HOVER, ACTIVE): Color of the tabs\' background in hexadecimal format.</li>
\n  <li>TABS FONT  COLOR (REGULAR, HOVER, ACTIVE): Color of the tabs\' font in hexadecimal format.</li>
\n  <li>FOLDER  WHERE IMAGES ARE STORED: Type folder (relative to Joomla root) where  your images are stored. Don\'t include leading or trailing slash (in  example you may enter images/stories).</li>
\n  <li>WIDTH OF THE IMAGES: Self explanatory.</li>
\n  <li>HEIGHT OF THE IMAGES: Self explanatory. It also determines overall module height.</li>
\n  <li>HEADING OF ARTICLE: Please type heading of the article here.</li>
\n  <li>LINK  TO ARTICLE PAGE: Please type link to the full article here, starting  with http://. You can use internal or external links (internal link  example http://www.yoursite.com/index.php, or external link  http://www.google.com). If you don\'t type a link, heading and image  would be displayed without link.</li>
\n  <li>ARTICLE INFO TEXT: Please type short article information text for each featured article. HTML code allowed here.</li>
\n  <li>IMAGE NAMES: Image name with extension (in example articles.jpg).</li>
\n</ul>","","1","9","2011-01-22 16:20:18","647","","0000-00-00 00:00:00","0","0","0000-00-00 00:00:00","2011-01-22 16:20:18","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","0","","","1","33","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");
INSERT INTO #__content VALUES("26","64","Five Background Images","five-background-images","<p>This template comes with five background images. Background can be a solid color of your choice as well. All background images will fit perfectly onto screen, no matter what screen resolution you have. To change background image is simple. Go to the template parameters and select a background from the drop-down menu. If you select \"none\" for background image, the template will have a solid color background. The solid color of your choice can also be defined in the template parameters.</p>","","1","10","2011-01-29 17:16:09","647","","0000-00-00 00:00:00","0","0","0000-00-00 00:00:00","2011-01-29 17:16:09","0000-00-00 00:00:00","","","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}","1","0","","","1","10","{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","0","*","","");



DROP TABLE IF EXISTS #__content_frontpage;

CREATE TABLE `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__content_frontpage VALUES("1","1");
INSERT INTO #__content_frontpage VALUES("2","2");
INSERT INTO #__content_frontpage VALUES("3","3");



DROP TABLE IF EXISTS #__content_rating;

CREATE TABLE `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__content_types;

CREATE TABLE `#__content_types` (
  `type_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__content_types VALUES("1","Article","com_content.article","{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"Content\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\", \"note\":\"note\"}, \"special\":{\"fulltext\":\"fulltext\"}}","ContentHelperRoute::getArticleRoute","{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}");
INSERT INTO #__content_types VALUES("2","Contact","com_contact.contact","{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"Contact\",\"prefix\":\"ContactTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}","ContactHelperRoute::getContactRoute","{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }");
INSERT INTO #__content_types VALUES("3","Newsfeed","com_newsfeeds.newsfeed","{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"Newsfeed\",\"prefix\":\"NewsfeedsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}","NewsfeedsHelperRoute::getNewsfeedRoute","{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}");
INSERT INTO #__content_types VALUES("4","User","com_users.user","{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"User\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerdate\",\"core_modified_time\":\"lastvisitDate\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}","UsersHelperRoute::getUserRoute","");
INSERT INTO #__content_types VALUES("5","Article Category","com_content.category","{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}","ContentHelperRoute::getCategoryRoute","{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}");
INSERT INTO #__content_types VALUES("6","Contact Category","com_contact.category","{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}","ContactHelperRoute::getCategoryRoute","{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}");
INSERT INTO #__content_types VALUES("7","Newsfeeds Category","com_newsfeeds.category","{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}","NewsfeedsHelperRoute::getCategoryRoute","{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}");
INSERT INTO #__content_types VALUES("8","Tag","com_tags.tag","{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"Tag\",\"prefix\":\"TagsTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}","TagsHelperRoute::getTagRoute","{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}");
INSERT INTO #__content_types VALUES("9","Banner","com_banners.banner","{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"Banner\",\"prefix\":\"BannersTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}","","{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}");
INSERT INTO #__content_types VALUES("10","Banners Category","com_banners.category","{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}","","{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}");
INSERT INTO #__content_types VALUES("11","Banner Client","com_banners.client","{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"Client\",\"prefix\":\"BannersTable\"}}","","","","{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}");
INSERT INTO #__content_types VALUES("12","User Notes","com_users.note","{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"Note\",\"prefix\":\"UsersTable\"}}","","","","{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}");
INSERT INTO #__content_types VALUES("13","User Notes Category","com_users.category","{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}","","{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}","","{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}");



DROP TABLE IF EXISTS #__contentitem_tag_map;

CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int(10) unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';

INSERT INTO #__contentitem_tag_map VALUES("com_content.article","1","20","2","2013-05-10 13:33:41","1");
INSERT INTO #__contentitem_tag_map VALUES("com_content.article","1","20","3","2013-05-10 13:33:41","1");



DROP TABLE IF EXISTS #__core_log_searches;

CREATE TABLE `#__core_log_searches` (
  `search_term` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__extensions;

CREATE TABLE `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '0',
  `access` int(10) unsigned DEFAULT NULL,
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `system_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10019 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__extensions VALUES("1","0","com_mailto","component","com_mailto","","0","1","1","1","{\"name\":\"com_mailto\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MAILTO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mailto\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("2","0","com_wrapper","component","com_wrapper","","0","1","1","1","{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"wrapper\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("3","0","com_admin","component","com_admin","","1","1","1","1","{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("4","0","com_banners","component","com_banners","","1","1","1","0","{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}","{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("5","0","com_cache","component","com_cache","","1","1","1","1","{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("6","0","com_categories","component","com_categories","","1","1","1","1","{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("7","0","com_checkin","component","com_checkin","","1","1","1","1","{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("8","0","com_contact","component","com_contact","","1","1","1","0","{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}","{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"save_history\":\"0\",\"history_limit\":5,\"show_contact_list\":\"0\",\"presentation_style\":\"sliders\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_misc\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"show_profile\":\"0\",\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_tags\":\"1\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"1\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("9","0","com_cpanel","component","com_cpanel","","1","1","1","1","{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("10","0","com_installer","component","com_installer","","1","1","1","1","{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("11","0","com_languages","component","com_languages","","1","1","1","1","{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}","{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("12","0","com_login","component","com_login","","1","1","1","1","{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("13","0","com_media","component","com_media","","1","1","0","1","{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}","{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\",\"enable_flash\":\"0\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("14","0","com_menus","component","com_menus","","1","1","1","1","{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("15","0","com_messages","component","com_messages","","1","1","1","1","{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("16","0","com_modules","component","com_modules","","1","1","1","1","{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("17","0","com_newsfeeds","component","com_newsfeeds","","1","1","1","0","{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}","{\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_word_count\":\"0\",\"show_headings\":\"1\",\"show_name\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"display_num\":\"\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\",\"show_cat_items\":\"1\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("18","0","com_plugins","component","com_plugins","","1","1","1","1","{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("19","0","com_search","component","com_search","","1","1","1","0","{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"search\"}","{\"enabled\":\"0\",\"show_date\":\"1\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("20","0","com_templates","component","com_templates","","1","1","1","1","{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}","{\"template_positions_display\":\"0\",\"upload_limit\":\"2\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("21","0","com_weblinks","component","com_weblinks","","1","1","1","0","{\"name\":\"com_weblinks\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}","{\"show_comp_description\":\"1\",\"comp_description\":\"\",\"show_link_hits\":\"1\",\"show_link_description\":\"1\",\"show_other_cats\":\"0\",\"show_headings\":\"0\",\"show_numbers\":\"0\",\"show_report\":\"1\",\"count_clicks\":\"1\",\"target\":\"0\",\"link_icons\":\"\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("22","0","com_content","component","com_content","","1","1","0","1","{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}","{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"0\",\"show_intro\":\"1\",\"show_category\":\"0\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"0\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"100\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"category_layout\":\"_:blog\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"0\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"filters\":{\"1\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("23","0","com_config","component","com_config","","1","1","0","1","{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\"}","{\"filters\":{\"1\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("24","0","com_redirect","component","com_redirect","","1","1","0","1","{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("25","0","com_users","component","com_users","","1","1","0","1","{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}","{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"useractivation\":\"1\",\"frontend_userparams\":\"1\",\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("27","0","com_finder","component","com_finder","","1","1","0","0","{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}","{\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_advanced\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stemmer\":\"porter_en\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("28","0","com_joomlaupdate","component","com_joomlaupdate","","1","1","0","1","{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"February 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.2\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}","{\"updatesource\":\"sts\",\"customurl\":\"\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("29","0","com_tags","component","com_tags","","1","1","1","1","{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"December 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("30","0","com_contenthistory","component","com_contenthistory","","1","1","1","0","{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"May 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contenthistory\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("31","0","com_ajax","component","com_ajax","","1","1","1","1","{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ajax\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("32","0","com_postinstall","component","com_postinstall","","1","1","1","1","{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("33","0","com_fields","component","com_fields","","1","1","1","0","{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("34","0","com_associations","component","com_associations","","1","1","1","0","{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"January 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("35","0","com_privacy","component","com_privacy","","1","1","1","1","{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacy\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("36","0","com_actionlogs","component","com_actionlogs","","1","1","1","1","{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\"}","{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_config\",\"com_contact\",\"com_content\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("102","0","LIB_PHPUTF8","library","phputf8","","0","1","1","1","{\"name\":\"LIB_PHPUTF8\",\"type\":\"library\",\"creationDate\":\"2006\",\"author\":\"Harry Fuecks\",\"copyright\":\"Copyright various authors\",\"authorEmail\":\"hfuecks@gmail.com\",\"authorUrl\":\"http:\\/\\/sourceforge.net\\/projects\\/phputf8\",\"version\":\"0.5\",\"description\":\"LIB_PHPUTF8_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phputf8\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("103","0","LIB_JOOMLA","library","joomla","","0","1","1","0","{\"name\":\"LIB_JOOMLA\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}","{\"mediaversion\":\"8b22f1e547e66e536ae47e0970366f95\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("104","0","LIB_IDNA","library","idna_convert","","0","1","1","1","{\"name\":\"LIB_IDNA\",\"type\":\"library\",\"creationDate\":\"2004\",\"author\":\"phlyLabs\",\"copyright\":\"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de\",\"authorEmail\":\"phlymail@phlylabs.de\",\"authorUrl\":\"http:\\/\\/phlylabs.de\",\"version\":\"0.8.0\",\"description\":\"LIB_IDNA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"idna_convert\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("105","0","FOF","library","fof","","0","1","1","1","{\"name\":\"FOF\",\"type\":\"library\",\"creationDate\":\"2015-04-22 13:15:32\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2015 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"2.4.3\",\"description\":\"LIB_FOF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fof\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("106","0","LIB_PHPASS","library","phpass","","0","1","1","1","{\"name\":\"LIB_PHPASS\",\"type\":\"library\",\"creationDate\":\"2004-2006\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"http:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpass\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("200","0","mod_articles_archive","module","mod_articles_archive","","0","1","1","0","{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_archive\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("201","0","mod_articles_latest","module","mod_articles_latest","","0","1","1","0","{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_latest\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("202","0","mod_articles_popular","module","mod_articles_popular","","0","1","1","0","{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_popular\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("203","0","mod_banners","module","mod_banners","","0","1","1","0","{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_banners\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("204","0","mod_breadcrumbs","module","mod_breadcrumbs","","0","1","1","1","{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_breadcrumbs\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("205","0","mod_custom","module","mod_custom","","0","1","1","1","{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("206","0","mod_feed","module","mod_feed","","0","1","1","0","{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("207","0","mod_footer","module","mod_footer","","0","1","1","0","{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_footer\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("208","0","mod_login","module","mod_login","","0","1","1","1","{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("209","0","mod_menu","module","mod_menu","","0","1","1","1","{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("210","0","mod_articles_news","module","mod_articles_news","","0","1","1","0","{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_news\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("211","0","mod_random_image","module","mod_random_image","","0","1","1","0","{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_random_image\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("212","0","mod_related_items","module","mod_related_items","","0","1","1","0","{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_related_items\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("213","0","mod_search","module","mod_search","","0","1","1","0","{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SEARCH_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_search\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("214","0","mod_stats","module","mod_stats","","0","1","1","0","{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("215","0","mod_syndicate","module","mod_syndicate","","0","1","1","1","{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_syndicate\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("216","0","mod_users_latest","module","mod_users_latest","","0","1","1","0","{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_users_latest\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("217","0","mod_weblinks","module","mod_weblinks","","0","1","1","0","{\"name\":\"mod_weblinks\",\"type\":\"module\",\"creationDate\":\"July 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("218","0","mod_whosonline","module","mod_whosonline","","0","1","1","0","{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_whosonline\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("219","0","mod_wrapper","module","mod_wrapper","","0","1","1","0","{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_wrapper\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("220","0","mod_articles_category","module","mod_articles_category","","0","1","1","0","{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_category\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("221","0","mod_articles_categories","module","mod_articles_categories","","0","1","1","0","{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_categories\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("222","0","mod_languages","module","mod_languages","","0","1","1","1","{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_languages\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("223","0","mod_finder","module","mod_finder","","0","1","0","0","{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_finder\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("300","0","mod_custom","module","mod_custom","","1","1","1","1","{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("301","0","mod_feed","module","mod_feed","","1","1","1","0","{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("302","0","mod_latest","module","mod_latest","","1","1","1","0","{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latest\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("303","0","mod_logged","module","mod_logged","","1","1","1","0","{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_logged\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("304","0","mod_login","module","mod_login","","1","1","1","1","{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("305","0","mod_menu","module","mod_menu","","1","1","1","0","{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("306","0","mod_online","module","mod_online","","1","1","1","0","","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("307","0","mod_popular","module","mod_popular","","1","1","1","0","{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_popular\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("308","0","mod_quickicon","module","mod_quickicon","","1","1","1","1","{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_quickicon\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("309","0","mod_status","module","mod_status","","1","1","1","0","{\"name\":\"mod_status\",\"type\":\"module\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_status\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("310","0","mod_submenu","module","mod_submenu","","1","1","1","0","{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_submenu\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("311","0","mod_title","module","mod_title","","1","1","1","0","{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_title\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("312","0","mod_toolbar","module","mod_toolbar","","1","1","1","1","{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_toolbar\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("313","0","mod_multilangstatus","module","mod_multilangstatus","","1","1","1","0","{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_multilangstatus\"}","{\"cache\":\"0\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("314","0","mod_version","module","mod_version","","1","1","1","0","{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_version\"}","{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("315","0","mod_stats_admin","module","mod_stats_admin","","1","1","1","0","{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats_admin\"}","{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("316","0","mod_tags_popular","module","mod_tags_popular","","0","1","1","0","{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_popular\"}","{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("317","0","mod_tags_similar","module","mod_tags_similar","","0","1","1","0","{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_similar\"}","{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("318","0","mod_sampledata","module","mod_sampledata","","1","1","1","0","{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sampledata\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("319","0","mod_latestactions","module","mod_latestactions","","1","1","1","0","{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latestactions\"}","{}","","","0","1970-01-01 00:00:00","0","0");
INSERT INTO #__extensions VALUES("320","0","mod_privacy_dashboard","module","mod_privacy_dashboard","","1","1","1","0","{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_privacy_dashboard\"}","{}","","","0","1970-01-01 00:00:00","0","0");
INSERT INTO #__extensions VALUES("400","0","plg_authentication_gmail","plugin","gmail","authentication","0","0","1","0","{\"name\":\"plg_authentication_gmail\",\"type\":\"plugin\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_GMAIL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"gmail\"}","{\"applysuffix\":\"0\",\"suffix\":\"\",\"verifypeer\":\"1\",\"user_blacklist\":\"\"}","","","0","0000-00-00 00:00:00","1","0");
INSERT INTO #__extensions VALUES("401","0","plg_authentication_joomla","plugin","joomla","authentication","0","1","1","1","{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("402","0","plg_authentication_ldap","plugin","ldap","authentication","0","0","1","0","{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ldap\"}","{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}","","","0","0000-00-00 00:00:00","3","0");
INSERT INTO #__extensions VALUES("403","0","plg_content_contact","plugin","contact","content","0","1","1","0","{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"January 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}","","","","0","0000-00-00 00:00:00","1","0");
INSERT INTO #__extensions VALUES("404","0","plg_content_emailcloak","plugin","emailcloak","content","0","1","1","0","{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"emailcloak\"}","{\"mode\":\"1\"}","","","0","0000-00-00 00:00:00","1","0");
INSERT INTO #__extensions VALUES("405","0","plg_content_geshi","plugin","geshi","content","0","0","1","0","{\"name\":\"plg_content_geshi\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"qbnz.com\\/highlighter\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_GESHI_XML_DESCRIPTION\",\"group\":\"\"}","{}","","","0","0000-00-00 00:00:00","2","0");
INSERT INTO #__extensions VALUES("406","0","plg_content_loadmodule","plugin","loadmodule","content","0","1","1","0","{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"loadmodule\"}","{\"style\":\"none\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("407","0","plg_content_pagebreak","plugin","pagebreak","content","0","1","1","0","{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}","{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}","","","0","0000-00-00 00:00:00","4","0");
INSERT INTO #__extensions VALUES("408","0","plg_content_pagenavigation","plugin","pagenavigation","content","0","1","1","0","{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagenavigation\"}","{\"position\":\"1\"}","","","0","0000-00-00 00:00:00","5","0");
INSERT INTO #__extensions VALUES("409","0","plg_content_vote","plugin","vote","content","0","1","1","0","{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}","{}","","","0","0000-00-00 00:00:00","6","0");
INSERT INTO #__extensions VALUES("410","0","plg_editors_codemirror","plugin","codemirror","editors","0","1","1","1","{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2017 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"http:\\/\\/codemirror.net\\/\",\"version\":\"5.40.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"codemirror\"}","{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}","","","0","0000-00-00 00:00:00","1","0");
INSERT INTO #__extensions VALUES("411","0","plg_editors_none","plugin","none","editors","0","1","1","1","{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"September 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"none\"}","{}","","","0","0000-00-00 00:00:00","2","0");
INSERT INTO #__extensions VALUES("412","0","plg_editors_tinymce","plugin","tinymce","editors","0","1","1","0","{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2019\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"4.5.11\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tinymce\"}","{\"mode\":\"1\",\"skin\":\"0\",\"compressed\":\"0\",\"cleanup_startup\":\"0\",\"cleanup_save\":\"2\",\"entity_encoding\":\"raw\",\"lang_mode\":\"0\",\"lang_code\":\"en\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"extended_elements\":\"\",\"toolbar\":\"top\",\"toolbar_align\":\"left\",\"html_height\":\"550\",\"html_width\":\"750\",\"element_path\":\"1\",\"fonts\":\"1\",\"paste\":\"1\",\"searchreplace\":\"1\",\"insertdate\":\"1\",\"format_date\":\"%Y-%m-%d\",\"inserttime\":\"1\",\"format_time\":\"%H:%M:%S\",\"colors\":\"1\",\"table\":\"1\",\"smilies\":\"1\",\"media\":\"1\",\"hr\":\"1\",\"directionality\":\"1\",\"fullscreen\":\"1\",\"style\":\"1\",\"layer\":\"1\",\"xhtmlxtras\":\"1\",\"visualchars\":\"1\",\"nonbreaking\":\"1\",\"template\":\"1\",\"blockquote\":\"1\",\"wordcount\":\"1\",\"advimage\":\"1\",\"advlink\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"inlinepopups\":\"1\",\"safari\":\"0\",\"custom_plugin\":\"\",\"custom_button\":\"\"}","","","0","0000-00-00 00:00:00","3","0");
INSERT INTO #__extensions VALUES("413","0","plg_editors-xtd_article","plugin","article","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"article\"}","{}","","","0","0000-00-00 00:00:00","1","0");
INSERT INTO #__extensions VALUES("414","0","plg_editors-xtd_image","plugin","image","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"image\"}","{}","","","0","0000-00-00 00:00:00","2","0");
INSERT INTO #__extensions VALUES("415","0","plg_editors-xtd_pagebreak","plugin","pagebreak","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}","{}","","","0","0000-00-00 00:00:00","3","0");
INSERT INTO #__extensions VALUES("416","0","plg_editors-xtd_readmore","plugin","readmore","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"readmore\"}","{}","","","0","0000-00-00 00:00:00","4","0");
INSERT INTO #__extensions VALUES("417","0","plg_search_categories","plugin","categories","search","0","1","1","0","{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}","{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("418","0","plg_search_contacts","plugin","contacts","search","0","1","1","0","{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}","{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("419","0","plg_search_content","plugin","content","search","0","1","1","0","{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}","{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("420","0","plg_search_newsfeeds","plugin","newsfeeds","search","0","1","1","0","{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}","{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("421","0","plg_search_weblinks","plugin","weblinks","search","0","1","1","0","{\"name\":\"plg_search_weblinks\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}","{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("422","0","plg_system_languagefilter","plugin","languagefilter","system","0","0","1","1","{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagefilter\"}","{}","","","0","0000-00-00 00:00:00","1","0");
INSERT INTO #__extensions VALUES("423","0","plg_system_p3p","plugin","p3p","system","0","1","1","0","{\"name\":\"plg_system_p3p\",\"type\":\"plugin\",\"creationDate\":\"September 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_P3P_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"p3p\"}","{\"headers\":\"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM\"}","","","0","0000-00-00 00:00:00","2","0");
INSERT INTO #__extensions VALUES("424","0","plg_system_cache","plugin","cache","system","0","0","1","1","{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cache\"}","{\"browsercache\":\"0\",\"cachetime\":\"15\"}","","","0","0000-00-00 00:00:00","3","0");
INSERT INTO #__extensions VALUES("425","0","plg_system_debug","plugin","debug","system","0","1","1","0","{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"debug\"}","{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}","","","0","0000-00-00 00:00:00","4","0");
INSERT INTO #__extensions VALUES("426","0","plg_system_log","plugin","log","system","0","1","1","1","{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"log\"}","{}","","","0","0000-00-00 00:00:00","5","0");
INSERT INTO #__extensions VALUES("427","0","plg_system_redirect","plugin","redirect","system","0","1","1","1","{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}","{}","","","0","0000-00-00 00:00:00","6","0");
INSERT INTO #__extensions VALUES("428","0","plg_system_remember","plugin","remember","system","0","1","1","1","{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"remember\"}","{}","","","0","0000-00-00 00:00:00","7","0");
INSERT INTO #__extensions VALUES("429","0","plg_system_sef","plugin","sef","system","0","1","1","0","{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sef\"}","{}","","","0","0000-00-00 00:00:00","8","0");
INSERT INTO #__extensions VALUES("430","0","plg_system_logout","plugin","logout","system","0","1","1","1","{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logout\"}","{}","","","0","0000-00-00 00:00:00","9","0");
INSERT INTO #__extensions VALUES("431","0","plg_user_contactcreator","plugin","contactcreator","user","0","0","1","0","{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contactcreator\"}","{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}","","","0","0000-00-00 00:00:00","1","0");
INSERT INTO #__extensions VALUES("432","0","plg_user_joomla","plugin","joomla","user","0","1","1","0","{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}","{\"autoregister\":\"1\"}","","","0","0000-00-00 00:00:00","2","0");
INSERT INTO #__extensions VALUES("433","0","plg_user_profile","plugin","profile","user","0","0","1","0","{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"profile\"}","{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("434","0","plg_extension_joomla","plugin","joomla","extension","0","1","1","1","{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}","{}","","","0","0000-00-00 00:00:00","1","0");
INSERT INTO #__extensions VALUES("435","0","plg_content_joomla","plugin","joomla","content","0","1","1","0","{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("436","0","plg_system_languagecode","plugin","languagecode","system","0","0","1","0","{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagecode\"}","{}","","","0","0000-00-00 00:00:00","10","0");
INSERT INTO #__extensions VALUES("437","0","plg_quickicon_joomlaupdate","plugin","joomlaupdate","quickicon","0","1","1","1","{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomlaupdate\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("438","0","plg_quickicon_extensionupdate","plugin","extensionupdate","quickicon","0","1","1","1","{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"extensionupdate\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("439","0","plg_captcha_recaptcha","plugin","recaptcha","captcha","0","1","1","0","{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.4.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha\"}","{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("440","0","plg_system_highlight","plugin","highlight","system","0","1","1","0","{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"highlight\"}","{}","","","0","0000-00-00 00:00:00","7","0");
INSERT INTO #__extensions VALUES("441","0","plg_content_finder","plugin","finder","content","0","0","1","0","{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("442","0","plg_finder_categories","plugin","categories","finder","0","1","1","0","{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}","{}","","","0","0000-00-00 00:00:00","1","0");
INSERT INTO #__extensions VALUES("443","0","plg_finder_contacts","plugin","contacts","finder","0","1","1","0","{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}","{}","","","0","0000-00-00 00:00:00","2","0");
INSERT INTO #__extensions VALUES("444","0","plg_finder_content","plugin","content","finder","0","1","1","0","{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}","{}","","","0","0000-00-00 00:00:00","3","0");
INSERT INTO #__extensions VALUES("445","0","plg_finder_newsfeeds","plugin","newsfeeds","finder","0","1","1","0","{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}","{}","","","0","0000-00-00 00:00:00","4","0");
INSERT INTO #__extensions VALUES("446","0","plg_finder_weblinks","plugin","weblinks","finder","0","1","1","0","{\"name\":\"plg_finder_weblinks\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2014 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_WEBLINKS_XML_DESCRIPTION\",\"group\":\"\"}","{}","","","0","0000-00-00 00:00:00","5","0");
INSERT INTO #__extensions VALUES("447","0","plg_finder_tags","plugin","tags","finder","0","1","1","0","{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"February 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("448","0","plg_twofactorauth_totp","plugin","totp","twofactorauth","0","0","1","0","{\"name\":\"plg_twofactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"totp\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("449","0","plg_authentication_cookie","plugin","cookie","authentication","0","1","1","0","{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"July 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTH_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cookie\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("450","0","plg_twofactorauth_yubikey","plugin","yubikey","twofactorauth","0","0","1","0","{\"name\":\"plg_twofactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"yubikey\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("451","0","plg_search_tags","plugin","tags","search","0","0","1","0","{\"name\":\"plg_search_tags\",\"type\":\"plugin\",\"creationDate\":\"March 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEARCH_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}","{\"search_limit\":\"50\",\"show_tagged_items\":\"1\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("452","0","plg_system_updatenotification","plugin","updatenotification","system","0","1","1","0","{\"name\":\"plg_system_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"May 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"updatenotification\"}","{\"lastrun\":1573730822}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("453","0","plg_editors-xtd_module","plugin","module","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"module\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("454","0","plg_system_stats","plugin","stats","system","0","1","1","0","{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"stats\"}","{\"mode\":3,\"lastrun\":\"\",\"unique_id\":\"a66b335e9b4937312b703478e1df02d7deee390d\",\"interval\":12}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("455","0","plg_installer_packageinstaller","plugin","packageinstaller","installer","0","1","1","1","{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"packageinstaller\"}","","","","0","0000-00-00 00:00:00","1","0");
INSERT INTO #__extensions VALUES("456","0","PLG_INSTALLER_FOLDERINSTALLER","plugin","folderinstaller","installer","0","1","1","1","{\"name\":\"PLG_INSTALLER_FOLDERINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"folderinstaller\"}","","","","0","0000-00-00 00:00:00","2","0");
INSERT INTO #__extensions VALUES("457","0","PLG_INSTALLER_URLINSTALLER","plugin","urlinstaller","installer","0","1","1","1","{\"name\":\"PLG_INSTALLER_URLINSTALLER\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"urlinstaller\"}","","","","0","0000-00-00 00:00:00","3","0");
INSERT INTO #__extensions VALUES("458","0","plg_quickicon_phpversioncheck","plugin","phpversioncheck","quickicon","0","1","1","1","{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpversioncheck\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("459","0","plg_editors-xtd_menu","plugin","menu","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menu\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("460","0","plg_editors-xtd_contact","plugin","contact","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"October 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("461","0","plg_system_fields","plugin","fields","system","0","1","1","0","{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("462","0","plg_fields_calendar","plugin","calendar","fields","0","1","1","0","{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"calendar\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("463","0","plg_fields_checkboxes","plugin","checkboxes","fields","0","1","1","0","{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkboxes\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("464","0","plg_fields_color","plugin","color","fields","0","1","1","0","{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"color\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("465","0","plg_fields_editor","plugin","editor","fields","0","1","1","0","{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"editor\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("466","0","plg_fields_imagelist","plugin","imagelist","fields","0","1","1","0","{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"imagelist\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("467","0","plg_fields_integer","plugin","integer","fields","0","1","1","0","{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"integer\"}","{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("468","0","plg_fields_list","plugin","list","fields","0","1","1","0","{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"list\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("469","0","plg_fields_media","plugin","media","fields","0","1","1","0","{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("470","0","plg_fields_radio","plugin","radio","fields","0","1","1","0","{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"radio\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("471","0","plg_fields_sql","plugin","sql","fields","0","1","1","0","{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sql\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("472","0","plg_fields_text","plugin","text","fields","0","1","1","0","{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"text\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("473","0","plg_fields_textarea","plugin","textarea","fields","0","1","1","0","{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"textarea\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("474","0","plg_fields_url","plugin","url","fields","0","1","1","0","{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"url\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("475","0","plg_fields_user","plugin","user","fields","0","1","1","0","{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("476","0","plg_fields_usergrouplist","plugin","usergrouplist","fields","0","1","1","0","{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"usergrouplist\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("477","0","plg_content_fields","plugin","fields","content","0","1","1","0","{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("478","0","plg_editors-xtd_fields","plugin","fields","editors-xtd","0","1","1","0","{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("479","0","plg_sampledata_blog","plugin","blog","sampledata","0","0","1","0","{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"blog\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("480","0","plg_system_sessiongc","plugin","sessiongc","system","0","1","1","0","{\"name\":\"plg_system_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"February 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6\",\"description\":\"PLG_SYSTEM_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sessiongc\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("481","0","plg_fields_repeatable","plugin","repeatable","fields","0","1","1","0","{\"name\":\"plg_fields_repeatable\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_FIELDS_REPEATABLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"repeatable\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("482","0","plg_content_confirmconsent","plugin","confirmconsent","content","0","0","1","0","{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"confirmconsent\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("483","0","PLG_SYSTEM_ACTIONLOGS","plugin","actionlogs","system","0","0","1","0","{\"name\":\"PLG_SYSTEM_ACTIONLOGS\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("484","0","PLG_ACTIONLOG_JOOMLA","plugin","joomla","actionlog","0","1","1","0","{\"name\":\"PLG_ACTIONLOG_JOOMLA\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("485","0","plg_system_privacyconsent","plugin","privacyconsent","system","0","0","1","0","{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacyconsent\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("486","0","plg_system_logrotation","plugin","logrotation","system","0","1","1","0","{\"name\":\"plg_system_logrotation\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_LOGROTATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logrotation\"}","{\"lastrun\":1573730822}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("487","0","plg_privacy_user","plugin","user","privacy","0","1","1","0","{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("488","0","plg_quickicon_privacycheck","plugin","privacycheck","quickicon","0","1","1","0","{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacycheck\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("489","0","plg_user_terms","plugin","terms","user","0","0","1","0","{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"terms\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("490","0","plg_privacy_contact","plugin","contact","privacy","0","1","1","0","{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("491","0","plg_privacy_content","plugin","content","privacy","0","1","1","0","{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("492","0","plg_privacy_message","plugin","message","privacy","0","1","1","0","{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"message\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("493","0","plg_privacy_actionlogs","plugin","actionlogs","privacy","0","1","1","0","{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("494","0","plg_captcha_recaptcha_invisible","plugin","recaptcha_invisible","captcha","0","0","1","0","{\"name\":\"plg_captcha_recaptcha_invisible\",\"type\":\"plugin\",\"creationDate\":\"November 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha_invisible\"}","{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("495","0","plg_privacy_consents","plugin","consents","privacy","0","1","1","0","{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"consents\"}","{}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("504","0","hathor","template","hathor","","1","1","1","0","{\"name\":\"hathor\",\"type\":\"template\",\"creationDate\":\"May 2010\",\"author\":\"Andrea Tarr\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"3.0.0\",\"description\":\"TPL_HATHOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}","{\"showSiteName\":\"0\",\"colourChoice\":\"0\",\"boldText\":\"0\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("600","802","English (en-GB)","language","en-GB","","0","1","1","1","{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"November 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.13\",\"description\":\"en-GB site language\",\"group\":\"\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("601","802","English (en-GB)","language","en-GB","","1","1","1","1","{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"November 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.13\",\"description\":\"en-GB administrator language\",\"group\":\"\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("700","0","files_joomla","file","joomla","","0","1","1","1","{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"November 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 - 2019 Open Source Matters. All rights reserved\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.13\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("801","0","weblinks","package","pkg_weblinks","","0","1","1","0","","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("802","0","English (en-GB) Language Pack","package","pkg_en-GB","","0","1","1","1","{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"November 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.13.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"filename\":\"pkg_en-GB\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("10008","0","HOT Joomla Gallery","module","mod_hot_joomla_gallery","","0","1","0","0","{\"legacy\":false,\"name\":\"HOT Joomla Gallery\",\"type\":\"module\",\"creationDate\":\"2009-11-20\",\"author\":\"HotJoomlaTemplates.com\",\"copyright\":\"All rights reserved by HotJoomlaTemplates.com\",\"authorEmail\":\"info@hotjoomlatemplates.com\",\"authorUrl\":\"http:\\/\\/www.hotjoomlatemplates.com\",\"version\":\"1.6\",\"description\":\"HOT Joomla Gallery - Free Joomla Module from HotJoomlaTemplates.com\",\"group\":\"\"}","{\"moduleclass_sfx\":\"\",\"enablejQuery\":\"1\",\"imageFolder\":\"images\\/stories\\/fruit\",\"bigImageWidth\":\"300\",\"bigImageHeight\":\"200\",\"userInput\":\"\",\"thumbsNumber\":\"3\",\"thumbsSize\":\"20\",\"timerValue\":\"3500\",\"galleryBackground\":\"000000\",\"galleryBorder\":\"6\",\"galleryBorderColor\":\"cccccc\",\"bigImageBorder\":\"0\",\"bigImageBorderColor\":\"cccccc\",\"thumbBorderColor\":\"cccccc\",\"activeThumbBorderColor\":\"ffffff\",\"descTextBackground\":\"000000\",\"descTextColor\":\"ffffff\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("10009","0","HOT Joomla Carousel","module","mod_hot_joomla_carousel","","0","1","0","0","{\"legacy\":false,\"name\":\"HOT Joomla Carousel\",\"type\":\"module\",\"creationDate\":\"2009-11-25\",\"author\":\"HotJoomlaTemplates.com\",\"copyright\":\"All rights reserved by HotJoomlaTemplates.com\",\"authorEmail\":\"info@hotjoomlatemplates.com\",\"authorUrl\":\"http:\\/\\/www.hotjoomlatemplates.com\",\"version\":\"1.6\",\"description\":\"HOT Joomla Carousel - Free Joomla Module from HotJoomlaTemplates.com\",\"group\":\"\"}","{\"moduleclass_sfx\":\"\",\"enablejQuery\":\"1\",\"moduleWidth\":\"500\",\"moduleHeight\":\"136\",\"imageFolder\":\"images\\/stories\",\"imageNumber\":\"3\",\"imageWidth\":\"145\",\"imageHeight\":\"128\",\"imageMargin\":\"10\",\"imagePadding\":\"2\",\"imageBorderWidth\":\"2\",\"imageBorderColor\":\"#000000\",\"carouselPagination\":\"false\",\"carouselAutoSlide\":\"false\",\"carouselAutoSlideInterval\":\"3000\",\"carouselEffect\":\"slide\",\"carouselAnimSpeed\":\"normal\",\"carouselDirection\":\"normal\",\"carouselLoop\":\"false\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("10011","0","HOT Newsflash","module","mod_hot_newsflash","","0","1","0","0","{\"legacy\":false,\"name\":\"HOT Newsflash\",\"type\":\"module\",\"creationDate\":\"2009-10-06\",\"author\":\"HotJoomlaTemplates.com\",\"copyright\":\"All rights reserved by HotJoomlaTemplates.com\",\"authorEmail\":\"info@hotjoomlatemplates.com\",\"authorUrl\":\"http:\\/\\/www.hotjoomlatemplates.com\",\"version\":\"1.6\",\"description\":\"MODULE_DESC\",\"group\":\"\"}","{\"moduleclass_sfx\":\"\",\"enablejQuery\":\"1\",\"noConflictMode\":\"0\",\"moduleWidth\":\"600\",\"moduleBackground\":\"#ffffff\",\"borderWidth\":\"0\",\"borderColor\":\"#000000\",\"tabNumber\":\"4\",\"readMore\":\"1\",\"readMoreText\":\"Full story\",\"speed\":\"5000\",\"headingTextColor\":\"#000000\",\"mainTextColor\":\"#000000\",\"tabWidth\":\"150\",\"tabBgColor\":\"#ffffff\",\"tabBgColorHover\":\"#f2f2f2\",\"tabBgColorActive\":\"#000000\",\"tabFontColor\":\"#000000\",\"tabFontColorHover\":\"#000000\",\"tabFontColorActive\":\"#ffffff\",\"tabDelimiterColor\":\"#cccccc\",\"tabMultiline\":\"1\",\"imageWidth\":\"254\",\"imageHeight\":\"169\",\"imageLink\":\"1\",\"heading1\":\"\",\"link1\":\"\",\"info1\":\"\",\"image1\":\"\",\"heading2\":\"\",\"link2\":\"\",\"info2\":\"\",\"image2\":\"\",\"heading3\":\"\",\"link3\":\"\",\"info3\":\"\",\"image3\":\"\",\"heading4\":\"\",\"link4\":\"\",\"info4\":\"\",\"image4\":\"\",\"heading5\":\"\",\"link5\":\"\",\"info5\":\"\",\"image5\":\"\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("10012","0","hot_coffeine","template","hot_coffeine","","0","1","1","0","{\"legacy\":false,\"name\":\"hot_coffeine\",\"type\":\"template\",\"creationDate\":\"April 2009\",\"author\":\"HotJoomlaTemplates.com\",\"copyright\":\"Copyright 2010 by Hot Joomla Templates\",\"authorEmail\":\"info@hotjoomlatemplates.com\",\"authorUrl\":\"http:\\/\\/www.hotjoomlatemplates.com\",\"version\":\"1.6\",\"description\":\"Commercial template \\\"Hot Coffeine\\\" by Hot Joomla Templates\",\"group\":\"\"}","{\"templateWidth\":\"980\",\"columnLeftWidth\":\"285\",\"columnRightWidth\":\"285\",\"templateStyle\":\"1\",\"background\":\"fabric\",\"backgroundColor\":\"#000000\",\"backgroundHeader\":\"4\",\"topMenuBg\":\"#000000\",\"menuEffect\":\"drop_in\",\"topMenuButton\":\"#222222\",\"topMenuHoverButton\":\"#ffffff\",\"topMenuText\":\"#ffffff\",\"topMenuHoverText\":\"#222222\",\"mainMenuText\":\"#ffffff\",\"mainMenuHoverText\":\"#cccccc\",\"mainMenuTextActive\":\"#000000\",\"bodyText\":\"#c9c9c9\",\"bodyLink\":\"#000000\",\"breadcrumbsText\":\"#ffffff\",\"componentHeadingText\":\"#ffffff\",\"headingText\":\"#ffffff\",\"headingHoverText\":\"#e4e37c\",\"columnFirstWord\":\"#e4e37c\",\"columnHeading\":\"#ffffff\",\"columnBg\":\"#000000\",\"columnText\":\"#ffffff\",\"columnLink\":\"#000000\",\"columnBg2\":\"#5f3e0b\",\"columnText2\":\"#ffffff\",\"columnLink2\":\"#ffffff\",\"bottomBgColor\":\"#121212\",\"bottomTextColor\":\"#ffffff\",\"bottomLinkColor\":\"#ffffff\",\"footerTextColor\":\"#000000\",\"panelBg\":\"#51a0b1\",\"panelHeadings\":\"#ffffff\",\"panelBorder\":\"#ffffff\",\"panelText\":\"#dddddd\",\"imageReflectionLoad\":\"1\",\"fontResizeLoad\":\"1\",\"lightboxLoad\":\"1\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("10013","0","HOT Effects Rotator","module","mod_hot_effects_rotator","","0","1","0","0","{\"legacy\":false,\"name\":\"HOT Effects Rotator\",\"type\":\"module\",\"creationDate\":\"2010-03-31\",\"author\":\"HotJoomlaTemplates.com\",\"copyright\":\"All rights reserved by Arhimedia Network\",\"authorEmail\":\"info@hotjoomlatemplates.com\",\"authorUrl\":\"http:\\/\\/www.hotjoomlatemplates.com\",\"version\":\"1.6\",\"description\":\"HOT Effects Rotator - Commercial Joomla Module from HotJoomlaTemplates.com\",\"group\":\"\"}","{\"moduleclass_sfx\":\"\",\"enablejQuery\":\"1\",\"sliderWidth\":\"300\",\"sliderHeight\":\"150\",\"linkNewWindow\":\"0\",\"transitionEffect\":\"random\",\"slices\":\"15\",\"animSpeed\":\"500\",\"pauseTime\":\"3000\",\"directionNav\":\"1\",\"directionNavHide\":\"0\",\"controlNav\":\"1\",\"pauseOnHover\":\"1\",\"manualAdvance\":\"0\",\"image1\":\"\",\"image1desc\":\"\",\"image1link\":\"\",\"image2\":\"\",\"image2desc\":\"\",\"image2link\":\"\",\"image3\":\"\",\"image3desc\":\"\",\"image3link\":\"\",\"image4\":\"\",\"image4desc\":\"\",\"image4link\":\"\",\"image5\":\"\",\"image5desc\":\"\",\"image5link\":\"\",\"image6\":\"\",\"image6desc\":\"\",\"image6link\":\"\",\"image7\":\"\",\"image7desc\":\"\",\"image7link\":\"\",\"image8\":\"\",\"image8desc\":\"\",\"image8link\":\"\",\"image9\":\"\",\"image9desc\":\"\",\"image9link\":\"\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("10014","0","PKG_JOOMLA","package","pkg_joomla","","0","1","1","1","{\"legacy\":false,\"name\":\"PKG_JOOMLA\",\"type\":\"package\",\"creationDate\":\"2006\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"http:\\/\\/www.joomla.org\",\"version\":\"2.5.0\",\"description\":\"PKG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}","","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("10015","0","isis","template","isis","","1","1","1","0","{\"name\":\"isis\",\"type\":\"template\",\"creationDate\":\"3\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ISIS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}","{\"templateColor\":\"\",\"logoFile\":\"\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("10016","0","protostar","template","protostar","","0","1","1","0","{\"name\":\"protostar\",\"type\":\"template\",\"creationDate\":\"4\\/30\\/2012\",\"author\":\"Kyle Ledbetter\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_PROTOSTAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}","{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("10017","0","beez3","template","beez3","","0","1","1","0","{\"name\":\"beez3\",\"type\":\"template\",\"creationDate\":\"25 November 2009\",\"author\":\"Angie Radtke\",\"copyright\":\"Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.\",\"authorEmail\":\"a.radtke@derauftritt.de\",\"authorUrl\":\"http:\\/\\/www.der-auftritt.de\",\"version\":\"3.1.0\",\"description\":\"TPL_BEEZ3_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templateDetails\"}","{\"wrapperSmall\":\"53\",\"wrapperLarge\":\"72\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"templatecolor\":\"nature\"}","","","0","0000-00-00 00:00:00","0","0");
INSERT INTO #__extensions VALUES("10018","0","mod_unread","module","mod_unread","","1","1","1","0","{\"name\":\"mod_unread\",\"type\":\"module\",\"creationDate\":\"Nov 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2005 - 2011 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"1.6.0\",\"description\":\"MOD_UNREAD_XML_DESCRIPTION\",\"group\":\"\"}","{\"cache\":\"0\"}","","","0","0000-00-00 00:00:00","0","0");



DROP TABLE IF EXISTS #__fields;

CREATE TABLE `#__fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__fields_categories;

CREATE TABLE `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__fields_groups;

CREATE TABLE `#__fields_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__fields_values;

CREATE TABLE `#__fields_values` (
  `field_id` int(10) unsigned NOT NULL,
  `item_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__finder_filters;

CREATE TABLE `#__finder_filters` (
  `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL,
  `created_by_alias` varchar(255) NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `map_count` int(10) unsigned NOT NULL DEFAULT '0',
  `data` mediumtext NOT NULL,
  `params` longtext,
  PRIMARY KEY (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links;

CREATE TABLE `#__finder_links` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `route` varchar(255) NOT NULL,
  `title` varchar(400) DEFAULT NULL,
  `description` text,
  `indexdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `md5sum` varchar(32) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `state` int(5) DEFAULT '1',
  `access` int(5) DEFAULT '0',
  `language` varchar(8) NOT NULL,
  `publish_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `list_price` double unsigned NOT NULL DEFAULT '0',
  `sale_price` double unsigned NOT NULL DEFAULT '0',
  `type_id` int(11) NOT NULL,
  `object` mediumblob NOT NULL,
  PRIMARY KEY (`link_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_md5` (`md5sum`),
  KEY `idx_url` (`url`(75)),
  KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),
  KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`),
  KEY `idx_title` (`title`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_terms0;

CREATE TABLE `#__finder_links_terms0` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_terms1;

CREATE TABLE `#__finder_links_terms1` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_terms2;

CREATE TABLE `#__finder_links_terms2` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_terms3;

CREATE TABLE `#__finder_links_terms3` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_terms4;

CREATE TABLE `#__finder_links_terms4` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_terms5;

CREATE TABLE `#__finder_links_terms5` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_terms6;

CREATE TABLE `#__finder_links_terms6` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_terms7;

CREATE TABLE `#__finder_links_terms7` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_terms8;

CREATE TABLE `#__finder_links_terms8` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_terms9;

CREATE TABLE `#__finder_links_terms9` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_termsa;

CREATE TABLE `#__finder_links_termsa` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_termsb;

CREATE TABLE `#__finder_links_termsb` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_termsc;

CREATE TABLE `#__finder_links_termsc` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_termsd;

CREATE TABLE `#__finder_links_termsd` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_termse;

CREATE TABLE `#__finder_links_termse` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_links_termsf;

CREATE TABLE `#__finder_links_termsf` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_taxonomy;

CREATE TABLE `#__finder_taxonomy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `state` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `access` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `state` (`state`),
  KEY `ordering` (`ordering`),
  KEY `access` (`access`),
  KEY `idx_parent_published` (`parent_id`,`state`,`access`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

INSERT INTO #__finder_taxonomy VALUES("1","0","ROOT","0","0","0");



DROP TABLE IF EXISTS #__finder_taxonomy_map;

CREATE TABLE `#__finder_taxonomy_map` (
  `link_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`link_id`,`node_id`),
  KEY `link_id` (`link_id`),
  KEY `node_id` (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_terms;

CREATE TABLE `#__finder_terms` (
  `term_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `weight` float unsigned NOT NULL DEFAULT '0',
  `soundex` varchar(75) NOT NULL,
  `links` int(10) NOT NULL DEFAULT '0',
  `language` char(3) NOT NULL DEFAULT '',
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `idx_term` (`term`),
  KEY `idx_term_phrase` (`term`,`phrase`),
  KEY `idx_stem_phrase` (`stem`,`phrase`),
  KEY `idx_soundex_phrase` (`soundex`,`phrase`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_terms_common;

CREATE TABLE `#__finder_terms_common` (
  `term` varchar(75) NOT NULL,
  `language` varchar(3) NOT NULL,
  KEY `idx_word_lang` (`term`,`language`),
  KEY `idx_lang` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO #__finder_terms_common VALUES("a","en");
INSERT INTO #__finder_terms_common VALUES("about","en");
INSERT INTO #__finder_terms_common VALUES("after","en");
INSERT INTO #__finder_terms_common VALUES("ago","en");
INSERT INTO #__finder_terms_common VALUES("all","en");
INSERT INTO #__finder_terms_common VALUES("am","en");
INSERT INTO #__finder_terms_common VALUES("an","en");
INSERT INTO #__finder_terms_common VALUES("and","en");
INSERT INTO #__finder_terms_common VALUES("ani","en");
INSERT INTO #__finder_terms_common VALUES("any","en");
INSERT INTO #__finder_terms_common VALUES("are","en");
INSERT INTO #__finder_terms_common VALUES("aren\'t","en");
INSERT INTO #__finder_terms_common VALUES("as","en");
INSERT INTO #__finder_terms_common VALUES("at","en");
INSERT INTO #__finder_terms_common VALUES("be","en");
INSERT INTO #__finder_terms_common VALUES("but","en");
INSERT INTO #__finder_terms_common VALUES("by","en");
INSERT INTO #__finder_terms_common VALUES("for","en");
INSERT INTO #__finder_terms_common VALUES("from","en");
INSERT INTO #__finder_terms_common VALUES("get","en");
INSERT INTO #__finder_terms_common VALUES("go","en");
INSERT INTO #__finder_terms_common VALUES("how","en");
INSERT INTO #__finder_terms_common VALUES("if","en");
INSERT INTO #__finder_terms_common VALUES("in","en");
INSERT INTO #__finder_terms_common VALUES("into","en");
INSERT INTO #__finder_terms_common VALUES("is","en");
INSERT INTO #__finder_terms_common VALUES("isn\'t","en");
INSERT INTO #__finder_terms_common VALUES("it","en");
INSERT INTO #__finder_terms_common VALUES("its","en");
INSERT INTO #__finder_terms_common VALUES("me","en");
INSERT INTO #__finder_terms_common VALUES("more","en");
INSERT INTO #__finder_terms_common VALUES("most","en");
INSERT INTO #__finder_terms_common VALUES("must","en");
INSERT INTO #__finder_terms_common VALUES("my","en");
INSERT INTO #__finder_terms_common VALUES("new","en");
INSERT INTO #__finder_terms_common VALUES("no","en");
INSERT INTO #__finder_terms_common VALUES("none","en");
INSERT INTO #__finder_terms_common VALUES("not","en");
INSERT INTO #__finder_terms_common VALUES("noth","en");
INSERT INTO #__finder_terms_common VALUES("nothing","en");
INSERT INTO #__finder_terms_common VALUES("of","en");
INSERT INTO #__finder_terms_common VALUES("off","en");
INSERT INTO #__finder_terms_common VALUES("often","en");
INSERT INTO #__finder_terms_common VALUES("old","en");
INSERT INTO #__finder_terms_common VALUES("on","en");
INSERT INTO #__finder_terms_common VALUES("onc","en");
INSERT INTO #__finder_terms_common VALUES("once","en");
INSERT INTO #__finder_terms_common VALUES("onli","en");
INSERT INTO #__finder_terms_common VALUES("only","en");
INSERT INTO #__finder_terms_common VALUES("or","en");
INSERT INTO #__finder_terms_common VALUES("other","en");
INSERT INTO #__finder_terms_common VALUES("our","en");
INSERT INTO #__finder_terms_common VALUES("ours","en");
INSERT INTO #__finder_terms_common VALUES("out","en");
INSERT INTO #__finder_terms_common VALUES("over","en");
INSERT INTO #__finder_terms_common VALUES("page","en");
INSERT INTO #__finder_terms_common VALUES("she","en");
INSERT INTO #__finder_terms_common VALUES("should","en");
INSERT INTO #__finder_terms_common VALUES("small","en");
INSERT INTO #__finder_terms_common VALUES("so","en");
INSERT INTO #__finder_terms_common VALUES("some","en");
INSERT INTO #__finder_terms_common VALUES("than","en");
INSERT INTO #__finder_terms_common VALUES("thank","en");
INSERT INTO #__finder_terms_common VALUES("that","en");
INSERT INTO #__finder_terms_common VALUES("the","en");
INSERT INTO #__finder_terms_common VALUES("their","en");
INSERT INTO #__finder_terms_common VALUES("theirs","en");
INSERT INTO #__finder_terms_common VALUES("them","en");
INSERT INTO #__finder_terms_common VALUES("then","en");
INSERT INTO #__finder_terms_common VALUES("there","en");
INSERT INTO #__finder_terms_common VALUES("these","en");
INSERT INTO #__finder_terms_common VALUES("they","en");
INSERT INTO #__finder_terms_common VALUES("this","en");
INSERT INTO #__finder_terms_common VALUES("those","en");
INSERT INTO #__finder_terms_common VALUES("thus","en");
INSERT INTO #__finder_terms_common VALUES("time","en");
INSERT INTO #__finder_terms_common VALUES("times","en");
INSERT INTO #__finder_terms_common VALUES("to","en");
INSERT INTO #__finder_terms_common VALUES("too","en");
INSERT INTO #__finder_terms_common VALUES("true","en");
INSERT INTO #__finder_terms_common VALUES("under","en");
INSERT INTO #__finder_terms_common VALUES("until","en");
INSERT INTO #__finder_terms_common VALUES("up","en");
INSERT INTO #__finder_terms_common VALUES("upon","en");
INSERT INTO #__finder_terms_common VALUES("use","en");
INSERT INTO #__finder_terms_common VALUES("user","en");
INSERT INTO #__finder_terms_common VALUES("users","en");
INSERT INTO #__finder_terms_common VALUES("veri","en");
INSERT INTO #__finder_terms_common VALUES("version","en");
INSERT INTO #__finder_terms_common VALUES("very","en");
INSERT INTO #__finder_terms_common VALUES("via","en");
INSERT INTO #__finder_terms_common VALUES("want","en");
INSERT INTO #__finder_terms_common VALUES("was","en");
INSERT INTO #__finder_terms_common VALUES("way","en");
INSERT INTO #__finder_terms_common VALUES("were","en");
INSERT INTO #__finder_terms_common VALUES("what","en");
INSERT INTO #__finder_terms_common VALUES("when","en");
INSERT INTO #__finder_terms_common VALUES("where","en");
INSERT INTO #__finder_terms_common VALUES("whi","en");
INSERT INTO #__finder_terms_common VALUES("which","en");
INSERT INTO #__finder_terms_common VALUES("who","en");
INSERT INTO #__finder_terms_common VALUES("whom","en");
INSERT INTO #__finder_terms_common VALUES("whose","en");
INSERT INTO #__finder_terms_common VALUES("why","en");
INSERT INTO #__finder_terms_common VALUES("wide","en");
INSERT INTO #__finder_terms_common VALUES("will","en");
INSERT INTO #__finder_terms_common VALUES("with","en");
INSERT INTO #__finder_terms_common VALUES("within","en");
INSERT INTO #__finder_terms_common VALUES("without","en");
INSERT INTO #__finder_terms_common VALUES("would","en");
INSERT INTO #__finder_terms_common VALUES("yes","en");
INSERT INTO #__finder_terms_common VALUES("yet","en");
INSERT INTO #__finder_terms_common VALUES("you","en");
INSERT INTO #__finder_terms_common VALUES("your","en");
INSERT INTO #__finder_terms_common VALUES("yours","en");



DROP TABLE IF EXISTS #__finder_tokens;

CREATE TABLE `#__finder_tokens` (
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `weight` float unsigned NOT NULL DEFAULT '1',
  `context` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `language` char(3) NOT NULL DEFAULT '',
  KEY `idx_word` (`term`),
  KEY `idx_context` (`context`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_tokens_aggregate;

CREATE TABLE `#__finder_tokens_aggregate` (
  `term_id` int(10) unsigned NOT NULL,
  `map_suffix` char(1) NOT NULL,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `term_weight` float unsigned NOT NULL,
  `context` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `context_weight` float unsigned NOT NULL,
  `total_weight` float unsigned NOT NULL,
  `language` char(3) NOT NULL DEFAULT '',
  KEY `token` (`term`),
  KEY `keyword_id` (`term_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__finder_types;

CREATE TABLE `#__finder_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `mime` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;




DROP TABLE IF EXISTS #__languages;

CREATE TABLE `#__languages` (
  `lang_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lang_code` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title_native` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sef` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `sitename` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__languages VALUES("1","0","en-GB","English (UK)","English (UK)","en","en","","","","","1","1","1");



DROP TABLE IF EXISTS #__menu;

CREATE TABLE `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned DEFAULT NULL,
  `img` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100))
) ENGINE=InnoDB AUTO_INCREMENT=199 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__menu VALUES("1","","Menu_Item_Root","root","","","","","1","0","0","0","0","0000-00-00 00:00:00","0","0","","0","","0","183","0","*","0");
INSERT INTO #__menu VALUES("2","main","com_banners","Banners","","Banners","index.php?option=com_banners","component","1","1","1","4","0","0000-00-00 00:00:00","0","0","class:banners","0","","1","10","0","*","1");
INSERT INTO #__menu VALUES("3","main","com_banners","Banners","","Banners/Banners","index.php?option=com_banners","component","1","2","2","4","0","0000-00-00 00:00:00","0","0","class:banners","0","","2","3","0","*","1");
INSERT INTO #__menu VALUES("4","main","com_banners_categories","Categories","","Banners/Categories","index.php?option=com_categories&extension=com_banners","component","1","2","2","6","0","0000-00-00 00:00:00","0","0","class:banners-cat","0","","4","5","0","*","1");
INSERT INTO #__menu VALUES("5","main","com_banners_clients","Clients","","Banners/Clients","index.php?option=com_banners&view=clients","component","1","2","2","4","0","0000-00-00 00:00:00","0","0","class:banners-clients","0","","6","7","0","*","1");
INSERT INTO #__menu VALUES("6","main","com_banners_tracks","Tracks","","Banners/Tracks","index.php?option=com_banners&view=tracks","component","1","2","2","4","0","0000-00-00 00:00:00","0","0","class:banners-tracks","0","","8","9","0","*","1");
INSERT INTO #__menu VALUES("7","main","com_contact","Contacts","","Contacts","index.php?option=com_contact","component","1","1","1","8","0","0000-00-00 00:00:00","0","0","class:contact","0","","21","26","0","*","1");
INSERT INTO #__menu VALUES("8","main","com_contact_contacts","Contacts","","Contacts/Contacts","index.php?option=com_contact","component","1","7","2","8","0","0000-00-00 00:00:00","0","0","class:contact","0","","22","23","0","*","1");
INSERT INTO #__menu VALUES("9","main","com_contact_categories","Categories","","Contacts/Categories","index.php?option=com_categories&extension=com_contact","component","1","7","2","6","0","0000-00-00 00:00:00","0","0","class:contact-cat","0","","24","25","0","*","1");
INSERT INTO #__menu VALUES("10","main","com_messages","Messaging","","Messaging","index.php?option=com_messages","component","1","1","1","15","0","0000-00-00 00:00:00","0","0","class:messages","0","","27","30","0","*","1");
INSERT INTO #__menu VALUES("11","main","com_messages_add","New Private Message","","Messaging/New Private Message","index.php?option=com_messages&task=message.add","component","1","10","2","15","0","0000-00-00 00:00:00","0","0","class:messages-add","0","","28","29","0","*","1");
INSERT INTO #__menu VALUES("13","main","com_newsfeeds","News Feeds","","News Feeds","index.php?option=com_newsfeeds","component","1","1","1","17","0","0000-00-00 00:00:00","0","0","class:newsfeeds","0","","31","36","0","*","1");
INSERT INTO #__menu VALUES("14","main","com_newsfeeds_feeds","Feeds","","News Feeds/Feeds","index.php?option=com_newsfeeds","component","1","13","2","17","0","0000-00-00 00:00:00","0","0","class:newsfeeds","0","","32","33","0","*","1");
INSERT INTO #__menu VALUES("15","main","com_newsfeeds_categories","Categories","","News Feeds/Categories","index.php?option=com_categories&extension=com_newsfeeds","component","1","13","2","6","0","0000-00-00 00:00:00","0","0","class:newsfeeds-cat","0","","34","35","0","*","1");
INSERT INTO #__menu VALUES("16","main","com_redirect","Redirect","","Redirect","index.php?option=com_redirect","component","1","1","1","24","0","0000-00-00 00:00:00","0","0","class:redirect","0","","45","46","0","*","1");
INSERT INTO #__menu VALUES("17","main","com_search","Search","","Search","index.php?option=com_search","component","1","1","1","19","0","0000-00-00 00:00:00","0","0","class:search","0","","37","38","0","*","1");
INSERT INTO #__menu VALUES("18","main","com_weblinks","Weblinks","","Weblinks","index.php?option=com_weblinks","component","1","1","1","21","0","0000-00-00 00:00:00","0","0","class:weblinks","0","","39","44","0","*","1");
INSERT INTO #__menu VALUES("19","main","com_weblinks_links","Links","","Weblinks/Links","index.php?option=com_weblinks","component","1","18","2","21","0","0000-00-00 00:00:00","0","0","class:weblinks","0","","40","41","0","*","1");
INSERT INTO #__menu VALUES("20","main","com_weblinks_categories","Categories","","Weblinks/Categories","index.php?option=com_categories&extension=com_weblinks","component","1","18","2","6","0","0000-00-00 00:00:00","0","0","class:weblinks-cat","0","","42","43","0","*","1");
INSERT INTO #__menu VALUES("23","main","com_tags","Tags","","Tags","index.php?option=com_tags","component","1","1","1","29","0","0000-00-00 00:00:00","0","1","class:tags","0","","47","48","0","","1");
INSERT INTO #__menu VALUES("101","mainmenu","Home Page","home","","home","index.php?option=com_content&view=featured","component","1","1","1","22","0","0000-00-00 00:00:00","0","1","","0","{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"3\",\"num_columns\":\"1\",\"num_links\":\"0\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"info_bloc_position\":\"0\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"Hot Coffeine - Joomla Cafe Template\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","11","12","1","*","0");
INSERT INTO #__menu VALUES("104","mainmenu","Module Positions","module-positions","","module-positions","index.php?option=com_content&view=article&id=15","component","1","1","1","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","15","16","0","*","0");
INSERT INTO #__menu VALUES("105","mainmenu","Unlimited Color Schemes","unlimited-color-schemes","","unlimited-color-schemes","index.php?option=com_content&view=article&id=16","component","1","1","1","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","17","18","0","*","0");
INSERT INTO #__menu VALUES("108","mainmenu","Adjustable Widths","adjustable-widths","","adjustable-widths","index.php?option=com_content&view=article&id=13","component","1","1","1","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","19","20","0","*","0");
INSERT INTO #__menu VALUES("111","topmenu","Home Page","home-page","","home-page","index.php?Itemid=","alias","1","1","1","0","0","0000-00-00 00:00:00","0","1","","0","{\"aliasoptions\":\"101\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\"}","51","52","0","*","0");
INSERT INTO #__menu VALUES("112","topmenu","HOT Menu","hot-menu","","hot-menu","index.php?option=com_content&view=article&id=9","component","1","1","1","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"1\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","65","74","0","*","0");
INSERT INTO #__menu VALUES("114","topmenu","Fade","fade","","hot-menu/fade","javascript:;","url","1","112","2","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","66","67","0","*","0");
INSERT INTO #__menu VALUES("115","topmenu","Scroll Down","scroll-down","","hot-menu/scroll-down","javascript:;","url","1","112","2","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","68","69","0","*","0");
INSERT INTO #__menu VALUES("116","topmenu","Drop-In","drop-in","","hot-menu/drop-in","javascript:;","url","1","112","2","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","70","71","0","*","0");
INSERT INTO #__menu VALUES("117","topmenu","No Effect","no-effect","","hot-menu/no-effect","javascript:;","url","1","112","2","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","72","73","0","*","0");
INSERT INTO #__menu VALUES("118","topmenu","Features","features","","features","javascript:;","url","1","1","1","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","75","110","0","*","0");
INSERT INTO #__menu VALUES("119","topmenu","Hot Joomla Gallery","hot-joomla-gallery","","features/extensions/hot-joomla-gallery","index.php?option=com_content&view=article&id=6","component","1","191","3","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","105","106","0","*","0");
INSERT INTO #__menu VALUES("120","topmenu","HOT Joomla Carousel","hot-joomla-carousel","","features/template-features/no-conflicts/hot-joomla-carousel","index.php?option=com_content&view=article&id=5","component","1","132","4","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","94","95","0","*","0");
INSERT INTO #__menu VALUES("121","topmenu","Template Features","template-features","","features/template-features","javascript:;","url","1","118","2","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","76","99","0","*","0");
INSERT INTO #__menu VALUES("123","topmenu","SEO Friendly","seo-friendly","","features/template-features/seo-friendly","index.php?option=com_content&view=article&id=10","component","1","121","3","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","77","78","0","*","0");
INSERT INTO #__menu VALUES("124","topmenu","Unlimited Colors","unlimited-colors","","features/template-features/unlimited-colors","index.php?Itemid=","alias","1","121","3","0","0","0000-00-00 00:00:00","0","1","","0","{\"aliasoptions\":\"105\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\"}","79","80","0","*","0");
INSERT INTO #__menu VALUES("125","topmenu","Adjustable Widths","adjustable-widths","","features/template-features/adjustable-widths","index.php?Itemid=","alias","1","121","3","0","0","0000-00-00 00:00:00","0","1","","0","{\"aliasoptions\":\"108\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\"}","81","82","0","*","0");
INSERT INTO #__menu VALUES("126","topmenu","20 Module Positions","20-module-positions","","features/template-features/20-module-positions","index.php?Itemid=","alias","1","121","3","0","0","0000-00-00 00:00:00","0","1","","0","{\"aliasoptions\":\"104\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\"}","83","84","0","*","0");
INSERT INTO #__menu VALUES("127","topmenu","Top Panel","top-panel","","features/template-features/top-panel","index.php?option=com_content&view=article&id=12","component","1","121","3","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","85","86","0","*","0");
INSERT INTO #__menu VALUES("128","topmenu","Lightbox","lightbox","","features/template-features/lightbox","index.php?option=com_content&view=article&id=14","component","1","121","3","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","87","88","0","*","0");
INSERT INTO #__menu VALUES("129","topmenu","Reflection Effect","reflection-effect","","features/template-features/reflection-effect","index.php?option=com_content&view=article&id=11","component","1","121","3","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","89","90","0","*","0");
INSERT INTO #__menu VALUES("130","topmenu","Font Resizer","font-resizer","","features/template-features/font-resizer","index.php?option=com_content&view=article&id=7","component","1","121","3","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","91","92","0","*","0");
INSERT INTO #__menu VALUES("132","topmenu","No Conflicts","no-conflicts","","features/template-features/no-conflicts","index.php?option=com_content&view=article&id=4","component","1","121","3","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","93","96","0","*","0");
INSERT INTO #__menu VALUES("140","topmenu","Joomla Stuff","joomla-stuff","","joomla-stuff","javascript:;","url","1","1","1","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","111","124","0","*","0");
INSERT INTO #__menu VALUES("141","topmenu","Blog","blog","","joomla-stuff/blog","index.php?option=com_content&view=category&layout=blog&id=11","component","1","140","2","22","0","0000-00-00 00:00:00","0","1","","0","{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"num_leading_articles\":\"0\",\"num_intro_articles\":\"10\",\"num_columns\":\"1\",\"num_links\":\"0\",\"multi_column_order\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"info_bloc_position\":\"0\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","112","113","0","*","0");
INSERT INTO #__menu VALUES("142","topmenu","Search","search","","joomla-stuff/search","index.php?option=com_search&view=search","component","1","140","2","19","0","0000-00-00 00:00:00","0","1","","0","{\"search_areas\":\"\",\"show_date\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","114","115","0","*","0");
INSERT INTO #__menu VALUES("143","topmenu","FAQs","faqs","","joomla-stuff/faqs","index.php?option=com_content&view=category&id=12","component","1","140","2","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"page_subheading\":\"\",\"show_pagination_limit\":\"\",\"filter_field\":\"\",\"show_headings\":\"\",\"list_show_date\":\"\",\"date_format\":\"\",\"list_show_hits\":\"\",\"list_show_author\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"display_num\":\"10\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","116","117","0","*","0");
INSERT INTO #__menu VALUES("144","topmenu","Contacts","contacts","","joomla-stuff/contacts","index.php?option=com_contact&view=contact&id=1","component","1","140","2","8","0","0000-00-00 00:00:00","0","1","","0","{\"presentation_style\":\"\",\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","118","119","0","*","0");
INSERT INTO #__menu VALUES("145","topmenu","News Feeds","news-feeds","","joomla-stuff/news-feeds","index.php?option=com_newsfeeds&view=category&id=5","component","1","140","2","17","0","0000-00-00 00:00:00","0","1","","0","{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_items\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_articles\":\"\",\"show_link\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","120","121","0","*","0");
INSERT INTO #__menu VALUES("146","topmenu","Web Links","web-links","","joomla-stuff/web-links","index.php?option=com_weblinks&view=category&id=6","component","1","140","2","21","0","0000-00-00 00:00:00","0","1","","0","{\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_links\":\"\",\"show_pagination_limit\":\"\",\"show_headings\":\"\",\"show_link_description\":\"\",\"show_link_hits\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","122","123","0","*","0");
INSERT INTO #__menu VALUES("147","topmenu","How To Install","how-to-install","","how-to-install","javascript:;","url","1","1","1","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","125","134","0","*","0");
INSERT INTO #__menu VALUES("148","topmenu","Basic Installation","basic-installation","","how-to-install/basic-installation","index.php?option=com_content&view=article&id=23","component","1","147","2","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","126","127","0","*","0");
INSERT INTO #__menu VALUES("149","topmenu","HOT Start","hot-start","","how-to-install/hot-start","index.php?option=com_content&view=article&id=24","component","1","147","2","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","128","129","0","*","0");
INSERT INTO #__menu VALUES("150","topmenu","Using Lightbox","using-lightbox","","how-to-install/using-lightbox","index.php?Itemid=","alias","1","147","2","0","0","0000-00-00 00:00:00","0","1","","0","{\"aliasoptions\":\"128\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\"}","130","131","0","*","0");
INSERT INTO #__menu VALUES("151","topmenu","Using Reflection","using-reflection","","how-to-install/using-reflection","index.php?Itemid=","alias","1","147","2","0","0","0000-00-00 00:00:00","0","1","","0","{\"aliasoptions\":\"129\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\"}","132","133","0","*","0");
INSERT INTO #__menu VALUES("152","topmenu","Typography","typo","","typo","index.php?option=com_content&view=article&id=8","component","1","1","1","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","135","136","0","*","0");
INSERT INTO #__menu VALUES("153","footermenu","Follow Us on Twitter!","follow-us-on-twitter","","follow-us-on-twitter","https://twitter.com/hot_themes","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","139","140","0","*","0");
INSERT INTO #__menu VALUES("154","footermenu","Facebook Fan Club","facebook-fan-club","","facebook-fan-club","https://www.facebook.com/hotthemes","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","141","142","0","*","0");
INSERT INTO #__menu VALUES("155","interestingmenu","Wikipedia Online","wikipedia-online","","wikipedia-online","http://www.wikipedia.org","url","1","1","1","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","143","144","0","*","0");
INSERT INTO #__menu VALUES("156","interestingmenu","Discovery Channel","discovery-channel","","discovery-channel","http://www.discovery.com","url","1","1","1","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","145","146","0","*","0");
INSERT INTO #__menu VALUES("157","interestingmenu","You Tube Videos","you-tube-videos","","you-tube-videos","http://www.youtube.com/user/hotjoomla","url","1","1","1","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","147","148","0","*","0");
INSERT INTO #__menu VALUES("158","interestingmenu","Flickr Online Images","flickr-online-images","","flickr-online-images","http://www.flickr.com","url","1","1","1","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","149","150","0","*","0");
INSERT INTO #__menu VALUES("159","interestingmenu","Apple iPhone Mobile","apple-iphone-mobile","","apple-iphone-mobile","http://www.apple.com/iphone/","url","1","1","1","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","151","152","0","*","0");
INSERT INTO #__menu VALUES("165","resourcesmenu","Joomla! Home","joomla-home2","","joomla-home2","https://www.joomla.org","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","153","154","0","*","0");
INSERT INTO #__menu VALUES("166","resourcesmenu","Joomla! Magazine","joomla-magazine","","joomla-magazine","http://magazine.joomla.org/","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","157","158","0","*","0");
INSERT INTO #__menu VALUES("167","resourcesmenu","Joomla! Forums","joomla-forums","","joomla-forums","https://forum.joomla.org/","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","159","160","0","*","0");
INSERT INTO #__menu VALUES("168","resourcesmenu","Joomla! Documentation","joomla-documentation","","joomla-documentation","https://docs.joomla.org/","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","155","156","0","*","0");
INSERT INTO #__menu VALUES("169","resourcesmenu","Joomla! Community","joomla-community","","joomla-community","https://community.joomla.org/","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","161","162","0","*","0");
INSERT INTO #__menu VALUES("170","hotjoomlamenu","Visit our Main Site","visit-our-main-site","","visit-our-main-site","#","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","163","164","0","*","0");
INSERT INTO #__menu VALUES("171","hotjoomlamenu","View Joomla Templates","order-joomla-templates","","order-joomla-templates","#","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","165","166","0","*","0");
INSERT INTO #__menu VALUES("172","hotjoomlamenu","Free Joomla Extensions","download-free-extensions","","download-free-extensions","#","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","167","168","0","*","0");
INSERT INTO #__menu VALUES("173","hotjoomlamenu","Read Joomla Tutorials","read-joomla-tutorials","","read-joomla-tutorials","#","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","169","170","0","*","0");
INSERT INTO #__menu VALUES("174","hotjoomlamenu","Support Forum","support-forum","","support-forum","#","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","171","172","0","*","0");
INSERT INTO #__menu VALUES("175","ourresourcesmenu","Joomla Tutorials","joomla-tutorials","","joomla-tutorials","#","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","173","174","0","*","0");
INSERT INTO #__menu VALUES("176","ourresourcesmenu","Forum Support","forum-support","","forum-support","#","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","175","176","0","*","0");
INSERT INTO #__menu VALUES("177","ourresourcesmenu","Free Joomla Extensions","free-extensions","","free-extensions","#","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","177","178","0","*","0");
INSERT INTO #__menu VALUES("183","topmenu","Predefined Styles","predefined-styles","","predefined-styles","javascript:;","url","1","1","1","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","53","64","0","*","0");
INSERT INTO #__menu VALUES("184","topmenu","Style 1","style-1","","predefined-styles/style-1","?style=1","url","1","183","2","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","54","55","0","*","0");
INSERT INTO #__menu VALUES("185","topmenu","Style 2","style-2","","predefined-styles/style-2","?style=2","url","1","183","2","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","56","57","0","*","0");
INSERT INTO #__menu VALUES("186","topmenu","Style 3","style-3","","predefined-styles/style-3","?style=3","url","1","183","2","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","58","59","0","*","0");
INSERT INTO #__menu VALUES("187","topmenu","Style 4","style-4","","predefined-styles/style-4","?style=4","url","1","183","2","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","60","61","0","*","0");
INSERT INTO #__menu VALUES("188","topmenu","Style 5","style-5","","predefined-styles/style-5","?style=5","url","1","183","2","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","62","63","0","*","0");
INSERT INTO #__menu VALUES("189","topmenu","Hot Newsflash","hot-newsflash","","features/extensions/hot-newsflash","index.php?option=com_content&view=article&id=25","component","1","191","3","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","103","104","0","*","0");
INSERT INTO #__menu VALUES("190","footermenu","Designed by HotThemes","copyright-2010-by-hot-joomla-templates","","copyright-2010-by-hot-joomla-templates","#","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","137","138","0","*","0");
INSERT INTO #__menu VALUES("191","topmenu","Extensions","extensions","","features/extensions","javascript:;","url","1","118","2","0","0","0000-00-00 00:00:00","0","1","","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}","100","109","0","*","0");
INSERT INTO #__menu VALUES("192","topmenu","Hot Effects Rotator","hot-effects-rotator","","features/extensions/hot-effects-rotator","index.php?option=com_content&view=article&id=2","component","1","191","3","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","101","102","0","*","0");
INSERT INTO #__menu VALUES("193","topmenu","5 Background Images","5-background-images","","features/template-features/5-background-images","index.php?option=com_content&view=article&id=26","component","1","121","3","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","97","98","0","*","0");
INSERT INTO #__menu VALUES("194","topmenu","Hot Joomla Carousel","hot-joomla-carousel","","features/extensions/hot-joomla-carousel","index.php?option=com_content&view=article&id=5","component","1","191","3","22","0","0000-00-00 00:00:00","0","1","","0","{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}","107","108","0","*","0");
INSERT INTO #__menu VALUES("195","main","com_postinstall","Post-installation messages","","Post-installation messages","index.php?option=com_postinstall","component","1","1","1","32","0","0000-00-00 00:00:00","0","1","class:postinstall","0","","49","50","0","*","1");
INSERT INTO #__menu VALUES("196","main","com_joomlaupdate","com-joomlaupdate","","com-joomlaupdate","index.php?option=com_joomlaupdate","component","1","1","1","28","0","0000-00-00 00:00:00","0","1","class:joomlaupdate","0","{}","179","180","0","","1");
INSERT INTO #__menu VALUES("197","main","com_associations","multilingual-associations","","multilingual-associations","index.php?option=com_associations","component","1","1","1","34","0","0000-00-00 00:00:00","0","1","class:associations","0","{}","181","182","0","*","1");
INSERT INTO #__menu VALUES("198","mainmenu","Download Template","download-template","","download-template","https://hot-themes.com/members/cart.php?a=add&pid=16","url","1","1","1","0","0","0000-00-00 00:00:00","0","1"," ","0","{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1}","13","14","0","*","0");



DROP TABLE IF EXISTS #__menu_types;

CREATE TABLE `#__menu_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `menutype` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(48) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__menu_types VALUES("1","0","mainmenu","Main Menu","The main menu for the site","0");
INSERT INTO #__menu_types VALUES("2","0","topmenu","Top Menu","","0");
INSERT INTO #__menu_types VALUES("3","0","footermenu","Footer Menu","","0");
INSERT INTO #__menu_types VALUES("4","0","interestingmenu","Interesting Sites","","0");
INSERT INTO #__menu_types VALUES("5","0","resourcesmenu","Joomla Resources","","0");
INSERT INTO #__menu_types VALUES("6","0","hotjoomlamenu","Hot Joomla Templates","","0");
INSERT INTO #__menu_types VALUES("7","0","ourresourcesmenu","Our Resources","","0");



DROP TABLE IF EXISTS #__messages;

CREATE TABLE `#__messages` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id_to` int(10) unsigned NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`message_id`),
  KEY `useridto_state` (`user_id_to`,`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__messages_cfg;

CREATE TABLE `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `cfg_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `idx_user_var_name` (`user_id`,`cfg_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__modules;

CREATE TABLE `#__modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` int(10) unsigned DEFAULT NULL,
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__modules VALUES("1","0","Main Menu","","","1","left","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_menu","1","1","{\"menutype\":\"mainmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}","0","*");
INSERT INTO #__modules VALUES("2","0","Login","","","1","login","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_login","1","1","","1","*");
INSERT INTO #__modules VALUES("3","0","Popular Articles","","","3","cpanel","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_popular","3","1","{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}","1","*");
INSERT INTO #__modules VALUES("4","0","Recently Added Articles","","","4","cpanel","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_latest","3","1","{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}","1","*");
INSERT INTO #__modules VALUES("6","0","Unread Messages","","","1","header","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_unread","3","1","","1","*");
INSERT INTO #__modules VALUES("7","0","Online Users","","","2","header","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_online","3","1","","1","*");
INSERT INTO #__modules VALUES("8","0","Toolbar","","","1","toolbar","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_toolbar","3","1","","1","*");
INSERT INTO #__modules VALUES("9","0","Quick Icons","","","1","icon","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_quickicon","3","1","","1","*");
INSERT INTO #__modules VALUES("10","0","Logged-in Users","","","2","cpanel","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_logged","3","1","{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}","1","*");
INSERT INTO #__modules VALUES("12","0","Admin Menu","","","1","menu","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_menu","3","1","{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}","1","*");
INSERT INTO #__modules VALUES("13","0","Admin Submenu","","","1","submenu","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_submenu","3","1","","1","*");
INSERT INTO #__modules VALUES("14","0","User Status","","","2","status","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_status","3","1","","1","*");
INSERT INTO #__modules VALUES("15","0","Title","","","1","title","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_title","3","1","","1","*");
INSERT INTO #__modules VALUES("16","0","Member\'s Area","","","2","left","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_login","1","1","{\"pretext\":\"\",\"posttext\":\"\",\"login\":\"\",\"logout\":\"\",\"greeting\":\"1\",\"name\":\"0\",\"usesecure\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}","0","*");
INSERT INTO #__modules VALUES("17","0","Breadcrumbs","","","1","breadcrumbs","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_breadcrumbs","1","0","{\"showHere\":\"1\",\"showHome\":\"1\",\"homeText\":\"Home\",\"showLast\":\"1\",\"separator\":\"-\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}","0","*");
INSERT INTO #__modules VALUES("19","0","Our New Module","","<p><img src=\"images/stories/demo/coffee1.jpg\" border=\"0\" alt=\"coffee\" width=\"80\" height=\"80\" align=\"right\" style=\"margin-left:5px\" />Brand new module HOT Effects Rotator is included with template. This module makes slide show with selection of 9 effects. <a href=\"index.php?option=com_content&amp;view=article&amp;id=2&amp;Itemid=109\">Learn more</a></p>","1","advert1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_custom","1","0","{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","0","*");
INSERT INTO #__modules VALUES("20","0","About HOT Carousel","","<p><img src=\"images/stories/demo/coffee2.jpg\" border=\"0\" alt=\"coffee cup\" width=\"80\" height=\"80\" align=\"right\" style=\"margin-left:5px\" />Need to display your images as a carousel? Easily done with our new   Joomla extension. Again, usage is very simple. <a href=\"index.php?option=com_content&amp;view=article&amp;id=6&amp;Itemid=42\">Learn   more</a></p>","1","advert2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_custom","1","0","{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","0","*");
INSERT INTO #__modules VALUES("21","0","SEO Friendly","","<p><img src=\"images/stories/demo/coffee3.jpg\" alt=\"coffee bag\" width=\"80\" height=\"80\" align=\"right\" style=\"margin-left:5px\" />Even SEO beginners know that H1 and H2 tags are important and that Google spiders look for them when indexing your page.</p>","1","advert3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_custom","1","0","{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","0","*");
INSERT INTO #__modules VALUES("22","76","Copyright","","Copyright &copy; 2010. Designed by Hot Joomla Templates
\n<img src=\"templates/hot_snowflake/images/logo_footer.png\" width=\"95\" height=\"38\" alt=\"logo\" />","1","bottom","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_custom","1","0","{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*");
INSERT INTO #__modules VALUES("23","0","Footer Menu","","","0","footer","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_menu","1","0","{\"menutype\":\"footermenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}","0","*");
INSERT INTO #__modules VALUES("24","0","Joomla! Resources","","","0","panel1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_menu","1","1","{\"menutype\":\"resourcesmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}","0","*");
INSERT INTO #__modules VALUES("25","0","Hot Joomla Templates","","","0","panel2","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_menu","1","1","{\"menutype\":\"hotjoomlamenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}","0","*");
INSERT INTO #__modules VALUES("26","0","Interesting Sites","","","0","panel3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_menu","1","1","{\"menutype\":\"interestingmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}","0","*");
INSERT INTO #__modules VALUES("27","0","Top Panel","","<p>This panel contains four module positions: panel1, panel2, panel3 and panel4. If none of these have published modules, the panel will be hidden.</p>
\n<p>You have control over the panel settings. You can change panel\'s height (currently 250px), width (100%), background color and panel\'s button text (open/close).</p>","0","panel4","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_custom","1","1","{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","0","*");
INSERT INTO #__modules VALUES("29","0","Top Menu","","","0","user3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_menu","1","0","{\"menutype\":\"topmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"nav\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}","0","*");
INSERT INTO #__modules VALUES("30","72","Social Icons","","<ul id=\"bubble\">
\n<li><a class=\"icon feed\" href=\"#\" title=\"Full RSS Feed\"> </a></li>
\n<li><a class=\"icon twitter\" href=\"http://twitter.com/hot_themes\" title=\"Follow us on Twitter\"> </a></li>
\n<li><a class=\"icon facebook\" href=\"http://www.facebook.com/hotthemes\" title=\"We\'re on Facebook\"> </a></li>
\n<li><a class=\"icon delicious\" href=\"http://delicious.com/save\" title=\"Delicious\"> </a></li>
\n</ul>","1","user4","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_custom","1","1","{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*");
INSERT INTO #__modules VALUES("31","0","Search","","","2","user4","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_search","1","0","{\"label\":\"\",\"width\":\"40\",\"text\":\"\",\"button\":\"\",\"button_pos\":\"right\",\"imagebutton\":\"\",\"button_text\":\"\",\"set_itemid\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}","0","*");
INSERT INTO #__modules VALUES("32","0","Reflection Effect","","<p>Reflection script is incorporated in template. If you want an image to have it, use class \"reflect\" for your images. You can also control reflection\'s height and opacity.</p>
\n<p><a href=\"index.php?option=com_content&amp;view=article&amp;id=11&amp;Itemid=129\">Learn more about it here. </a></p>","1","user5","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_custom","1","1","{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","0","*");
INSERT INTO #__modules VALUES("33","0","HOT Start","","<p><a href=\"index.php?option=com_content&amp;view=article&amp;id=24&amp;Itemid=149\">Follow our instructions</a> to make a copy of this demo site to your server.</p>
\n<p>HOT Start! is available with each template. It allows you to create a copy of this demo.</p>","1","user6","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_custom","1","1","{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","0","*");
INSERT INTO #__modules VALUES("34","0","Lightbox Enabled","","<p>jQuery Lightbox available. Click on thumbnail picture will open bigger picture in the Lightbox.</p>
\n<p><a href=\"index.php?option=com_content&amp;view=article&amp;id=14&amp;Itemid=128\">Check out how this feature works on this page.</a></p>","1","user7","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_custom","1","1","{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","0","*");
INSERT INTO #__modules VALUES("35","0","Our Resources","","","0","user8","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_menu","1","1","{\"menutype\":\"ourresourcesmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}","0","*");
INSERT INTO #__modules VALUES("36","75","HOT Joomla Gallery","","","1","inset","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_hot_joomla_gallery","1","0","{\"moduleclass_sfx\":\"\",\"imageFolder\":\"images\\/stories\\/demo\\/gallery\",\"bigImageWidth\":\"750\",\"bigImageHeight\":\"250\",\"userInput\":\"01.jpg||Welcome to HOT Mobility - New Hot Joomla Template!;02.jpg||This template introduces two new extensions: HOT Joomla Gallery and HOT Joomla Carousel!;03.jpg||Breaking news: HOT Mobility is 100% iPhone compatible. Try this demo on iPhone.;04.jpg||Three drop-down menu effects available in template parameters: Fade, Scroll Down, Drop-In.;05.jpg||All that you see on this demo is available as layered Photoshop files.;06.jpg||HOT Start allows you to make a copy of this DEMO site on your server easily.;07.jpg||This template is SEO friendly. Joomla itself doesn\'t put headings in H1 and H2. With this template, it does!;08.jpg||15 background pattern images to choose from. You can select pattern in template parameters.\",\"thumbsNumber\":\"5\",\"thumbsSize\":\"14\",\"timerValue\":\"5000\",\"galleryBackground\":\"#ffffff\",\"galleryBorder\":\"0\",\"galleryBorderColor\":\"#cccccc\",\"bigImageBorder\":\"0\",\"bigImageBorderColor\":\"#cccccc\",\"thumbBorderColor\":\"#cccccc\",\"activeThumbBorderColor\":\"#ffffff\",\"descTextBackground\":\"#000000\",\"descTextColor\":\"#ffffff\",\"module_tag\":\"div\",\"bootstrap_size\":\"0\",\"header_tag\":\"h3\",\"header_class\":\"\",\"style\":\"0\"}","0","*");
INSERT INTO #__modules VALUES("37","0","HOT Joomla Carousel","","","1","inset","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_hot_joomla_carousel","1","0","{\"moduleclass_sfx\":\"\",\"enablejQuery\":\"0\",\"moduleWidth\":\"650\",\"moduleHeight\":\"134\",\"imageFolder\":\"images\\/stories\\/demo\\/carousel\",\"imageNumber\":\"2\",\"imageWidth\":\"284\",\"imageHeight\":\"128\",\"imageMargin\":\"30\",\"imagePadding\":\"2\",\"imageBorderWidth\":\"1\",\"imageBorderColor\":\"#444444\",\"carouselPagination\":\"false\",\"carouselAutoSlide\":\"false\",\"carouselAutoSlideInterval\":\"1000\",\"carouselEffect\":\"slide\",\"carouselAnimSpeed\":\"normal\",\"carouselDirection\":\"horizontal\",\"carouselLoop\":\"true\"}","0","*");
INSERT INTO #__modules VALUES("39","0","HOT Newsflash","","","1","inset","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_hot_newsflash","1","0","{\"moduleclass_sfx\":\"\",\"enablejQuery\":\"0\",\"noConflictMode\":\"0\",\"moduleWidth\":\"760\",\"moduleBackground\":\"#FFFFFF\",\"borderWidth\":\"0\",\"borderColor\":\"#000000\",\"tabNumber\":\"4\",\"readMore\":\"1\",\"readMoreText\":\"Full story\",\"speed\":\"5000\",\"headingTextColor\":\"#000000\",\"mainTextColor\":\"#000000\",\"tabWidth\":\"270\",\"tabBgColor\":\"#FFFFFF\",\"tabBgColorHover\":\"#F2F2F2\",\"tabBgColorActive\":\"#51A0B1\",\"tabFontColor\":\"#000000\",\"tabFontColorHover\":\"#000000\",\"tabFontColorActive\":\"#FFFFFF\",\"tabDelimiterColor\":\"#EEEEEE\",\"tabMultiline\":\"0\",\"imageWidth\":\"300\",\"imageHeight\":\"150\",\"imageLink\":\"1\",\"heading1\":\"Snow is a type of precipitation within the Earth\'s atmosphere...\",\"link1\":\"#\",\"info1\":\"<p>It\'s in the form of crystalline water ice, consisting of a multitude of snowflakes that fall from clouds. Since snow is composed of small ice particles, it is a granular material. It has an open and therefore soft structure, unless packed by external pressure. Snowflakes come in a variety of shapes.<\\/p>\",\"image1\":\"images\\/stories\\/demo\\/newsflash\\/snow1.jpg\",\"heading2\":\"Snowflakes are conglomerations of frozen ice crystals\",\"link2\":\"#\",\"info2\":\"<p>They begin as snow crystals which develop when microscopic supercooled cloud droplets freeze. Snowflakes come in a variety of sizes and shapes. Complex shapes emerge as the flake moves through differing temperature and humidity regimes.<\\/p>\",\"image2\":\"images\\/stories\\/demo\\/newsflash\\/snow2.jpg\",\"heading3\":\"What\'s Thunderstorm?\",\"link3\":\"#\",\"info3\":\"<p>Also known as a winter thunderstorm or a thunder snowstorm, is a rare thunderstorm with snow falling as the primary precipitation instead of rain. It commonly falls in regions of strong upward motion within the cold sector of extratropical cyclones.<\\/p>\",\"image3\":\"images\\/stories\\/demo\\/newsflash\\/snow3.jpg\",\"heading4\":\"Blizzards have a negative impact on local economies\",\"link4\":\"#\",\"info4\":\"<p>A blizzard is a severe storm condition characterized by low temperatures, strong winds, and heavy blowing snow. By definition, the difference between blizzard and a snowstorm is the strength of the wind. Ground blizzards are a variation on the traditional blizzard.<\\/p>\",\"image4\":\"images\\/stories\\/demo\\/newsflash\\/snow4.jpg\",\"heading5\":\"\",\"link5\":\"\",\"info5\":\"\",\"image5\":\"\"}","0","*");
INSERT INTO #__modules VALUES("40","0","Most Read","","","2","right","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_articles_popular","1","1","{\"catid\":[\"\"],\"count\":\"6\",\"show_front\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"-featured\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","0","*");
INSERT INTO #__modules VALUES("41","0","Latest News","","","1","right","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_articles_latest","1","1","{\"catid\":[\"\"],\"count\":\"6\",\"show_featured\":\"\",\"ordering\":\"c_dsc\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","0","*");
INSERT INTO #__modules VALUES("42","0","Who\'s Online","","","3","right","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_whosonline","1","1","{\"showmode\":\"0\",\"linknames\":\"0\",\"linktowhat\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}","0","*");
INSERT INTO #__modules VALUES("43","0","HOT Effects Rotator","","","1","inset","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_hot_effects_rotator","1","0","{\"moduleclass_sfx\":\"\",\"enablejQuery\":\"0\",\"sliderWidth\":\"568\",\"sliderHeight\":\"260\",\"linkNewWindow\":\"0\",\"transitionEffect\":\"random\",\"slices\":\"8\",\"animSpeed\":\"1000\",\"pauseTime\":\"5000\",\"directionNav\":\"1\",\"directionNavHide\":\"1\",\"controlNav\":\"1\",\"pauseOnHover\":\"1\",\"manualAdvance\":\"0\",\"image1\":\"images\\/stories\\/demo\\/slider\\/slide1.jpg\",\"image1desc\":\"Lorem ipsum dolor sit amet\",\"image1link\":\"\",\"image2\":\"images\\/stories\\/demo\\/slider\\/slide2.jpg\",\"image2desc\":\"\",\"image2link\":\"\",\"image3\":\"images\\/stories\\/demo\\/slider\\/slide3.jpg\",\"image3desc\":\"Lorem ipsum dolor sit amet\",\"image3link\":\"\",\"image4\":\"images\\/stories\\/demo\\/slider\\/slide4.jpg\",\"image4desc\":\"\",\"image4link\":\"\",\"image5\":\"images\\/stories\\/demo\\/slider\\/slide5.jpg\",\"image5desc\":\"\",\"image5link\":\"\",\"image6\":\"images\\/stories\\/demo\\/slider\\/slide6.jpg\",\"image6desc\":\"\",\"image6link\":\"\",\"image7\":\"\",\"image7desc\":\"\",\"image7link\":\"\",\"image8\":\"\",\"image8desc\":\"\",\"image8link\":\"\",\"image9\":\"\",\"image9desc\":\"\",\"image9link\":\"\"}","0","*");
INSERT INTO #__modules VALUES("44","0","About Gallery","","<p><img src=\"images/stories/demo/coffee4.jpg\" alt=\"coffee chocolate\" width=\"80\" height=\"80\" align=\"right\" style=\"margin-left:5px\" />Our new extension HOT Joomla Gallery is incorporated in this template. You can see how it works on this demo site. <a href=\"index.php?option=com_content&amp;view=article&amp;id=5&amp;Itemid=41\">Learn more</a></p>","1","advert4","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_custom","1","0","{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","0","*");
INSERT INTO #__modules VALUES("45","0","Font Resizer","","<div id=\"font_resize\"><a class=\"decreaseFont\" href=\"#\" title=\"Font Decrease\">A-</a> <a class=\"resetFont\" href=\"#\" title=\"Font Reset\">Reset</a> <a class=\"increaseFont\" href=\"#\" title=\"Font Increase\">A+</a></div>","3","user4","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_custom","1","0","{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","0","*");
INSERT INTO #__modules VALUES("46","0","Featured Module","","<p>To have a featured module like this, please type -featured in Module Class Suffix field. This will make the module to be marked as more important.</p>","3","left","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_custom","1","1","{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"-featured\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","0","*");
INSERT INTO #__modules VALUES("47","0","Latest Users","","","4","right","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","-2","mod_users_latest","1","1","{\"shownumber\":\"5\",\"linknames\":\"1\",\"linktowhat\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","0","*");
INSERT INTO #__modules VALUES("48","0","Statistics","","","1","right","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_stats","1","1","{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"1\",\"increase\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}","0","*");
INSERT INTO #__modules VALUES("49","0","Multilanguage status","","","1","status","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","0","mod_multilangstatus","3","1","{\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}","1","*");
INSERT INTO #__modules VALUES("50","0","Joomla Version","","","1","footer","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0000-00-00 00:00:00","1","mod_version","3","1","{\"format\":\"short\",\"product\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\"}","1","*");



DROP TABLE IF EXISTS #__modules_menu;

CREATE TABLE `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__modules_menu VALUES("1","0");
INSERT INTO #__modules_menu VALUES("2","0");
INSERT INTO #__modules_menu VALUES("3","0");
INSERT INTO #__modules_menu VALUES("4","0");
INSERT INTO #__modules_menu VALUES("6","0");
INSERT INTO #__modules_menu VALUES("7","0");
INSERT INTO #__modules_menu VALUES("8","0");
INSERT INTO #__modules_menu VALUES("9","0");
INSERT INTO #__modules_menu VALUES("10","0");
INSERT INTO #__modules_menu VALUES("12","0");
INSERT INTO #__modules_menu VALUES("13","0");
INSERT INTO #__modules_menu VALUES("14","0");
INSERT INTO #__modules_menu VALUES("15","0");
INSERT INTO #__modules_menu VALUES("16","0");
INSERT INTO #__modules_menu VALUES("17","0");
INSERT INTO #__modules_menu VALUES("19","101");
INSERT INTO #__modules_menu VALUES("20","101");
INSERT INTO #__modules_menu VALUES("21","101");
INSERT INTO #__modules_menu VALUES("22","0");
INSERT INTO #__modules_menu VALUES("23","0");
INSERT INTO #__modules_menu VALUES("24","0");
INSERT INTO #__modules_menu VALUES("25","0");
INSERT INTO #__modules_menu VALUES("26","0");
INSERT INTO #__modules_menu VALUES("27","0");
INSERT INTO #__modules_menu VALUES("28","0");
INSERT INTO #__modules_menu VALUES("29","0");
INSERT INTO #__modules_menu VALUES("30","0");
INSERT INTO #__modules_menu VALUES("31","0");
INSERT INTO #__modules_menu VALUES("32","0");
INSERT INTO #__modules_menu VALUES("33","0");
INSERT INTO #__modules_menu VALUES("34","0");
INSERT INTO #__modules_menu VALUES("35","0");
INSERT INTO #__modules_menu VALUES("36","119");
INSERT INTO #__modules_menu VALUES("37","194");
INSERT INTO #__modules_menu VALUES("39","189");
INSERT INTO #__modules_menu VALUES("40","-194");
INSERT INTO #__modules_menu VALUES("40","-189");
INSERT INTO #__modules_menu VALUES("40","-126");
INSERT INTO #__modules_menu VALUES("40","-119");
INSERT INTO #__modules_menu VALUES("40","-104");
INSERT INTO #__modules_menu VALUES("41","-194");
INSERT INTO #__modules_menu VALUES("41","-189");
INSERT INTO #__modules_menu VALUES("41","-126");
INSERT INTO #__modules_menu VALUES("41","-119");
INSERT INTO #__modules_menu VALUES("41","-104");
INSERT INTO #__modules_menu VALUES("42","101");
INSERT INTO #__modules_menu VALUES("42","111");
INSERT INTO #__modules_menu VALUES("43","101");
INSERT INTO #__modules_menu VALUES("43","111");
INSERT INTO #__modules_menu VALUES("43","192");
INSERT INTO #__modules_menu VALUES("44","101");
INSERT INTO #__modules_menu VALUES("44","111");
INSERT INTO #__modules_menu VALUES("45","0");
INSERT INTO #__modules_menu VALUES("46","101");
INSERT INTO #__modules_menu VALUES("46","111");
INSERT INTO #__modules_menu VALUES("47","-189");
INSERT INTO #__modules_menu VALUES("47","-126");
INSERT INTO #__modules_menu VALUES("47","-119");
INSERT INTO #__modules_menu VALUES("47","-104");
INSERT INTO #__modules_menu VALUES("48","-194");
INSERT INTO #__modules_menu VALUES("48","-189");
INSERT INTO #__modules_menu VALUES("48","-126");
INSERT INTO #__modules_menu VALUES("48","-119");
INSERT INTO #__modules_menu VALUES("48","-104");
INSERT INTO #__modules_menu VALUES("49","0");
INSERT INTO #__modules_menu VALUES("50","0");



DROP TABLE IF EXISTS #__newsfeeds;

CREATE TABLE `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `link` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) unsigned NOT NULL DEFAULT '1',
  `cache_time` int(10) unsigned NOT NULL DEFAULT '3600',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) unsigned DEFAULT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__newsfeeds VALUES("5","1","Joomla! Announcements","joomla-announcements","http://feeds.joomla.org/JoomlaAnnouncements","1","5","3600","0","0000-00-00 00:00:00","1","0","1","*","{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\"}","2011-01-18 11:31:32","647","","0000-00-00 00:00:00","0","","","{\"robots\":\"\",\"rights\":\"\"}","","0000-00-00 00:00:00","0000-00-00 00:00:00","","1","0","");
INSERT INTO #__newsfeeds VALUES("5","2","Joomla! Community Magazine","joomla-community-magazine","http://feeds.joomla.org/JoomlaMagazine","1","5","3600","0","0000-00-00 00:00:00","2","0","1","*","{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\"}","2011-01-18 11:31:47","647","","0000-00-00 00:00:00","0","","","{\"robots\":\"\",\"rights\":\"\"}","","0000-00-00 00:00:00","0000-00-00 00:00:00","","1","0","");
INSERT INTO #__newsfeeds VALUES("5","3","Joomla! Security News","joomla-security-news","http://feeds.joomla.org/JoomlaSecurityNews","1","5","3600","0","0000-00-00 00:00:00","3","0","1","*","{\"show_feed_image\":\"\",\"show_feed_description\":\"\",\"show_item_description\":\"\",\"feed_character_count\":\"0\",\"newsfeed_layout\":\"\"}","2011-01-18 11:32:01","647","","0000-00-00 00:00:00","0","","","{\"robots\":\"\",\"rights\":\"\"}","","0000-00-00 00:00:00","0000-00-00 00:00:00","","1","0","");



DROP TABLE IF EXISTS #__overrider;

CREATE TABLE `#__overrider` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `constant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `string` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__postinstall_messages;

CREATE TABLE `#__postinstall_messages` (
  `postinstall_message_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `extension_id` bigint(20) NOT NULL DEFAULT '700' COMMENT 'FK to #__extensions',
  `title_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language_extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT '1',
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT '1',
  PRIMARY KEY (`postinstall_message_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__postinstall_messages VALUES("1","700","PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE","PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY","PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION","plg_twofactorauth_totp","1","action","site://plugins/twofactorauth/totp/postinstall/actions.php","twofactorauth_postinstall_action","site://plugins/twofactorauth/totp/postinstall/actions.php","twofactorauth_postinstall_condition","3.2.0","1");
INSERT INTO #__postinstall_messages VALUES("2","700","COM_CPANEL_MSG_EACCELERATOR_TITLE","COM_CPANEL_MSG_EACCELERATOR_BODY","COM_CPANEL_MSG_EACCELERATOR_BUTTON","com_cpanel","1","action","admin://components/com_admin/postinstall/eaccelerator.php","admin_postinstall_eaccelerator_action","admin://components/com_admin/postinstall/eaccelerator.php","admin_postinstall_eaccelerator_condition","3.2.0","1");
INSERT INTO #__postinstall_messages VALUES("3","700","COM_CPANEL_WELCOME_BEGINNERS_TITLE","COM_CPANEL_WELCOME_BEGINNERS_MESSAGE","","com_cpanel","1","message","","","","","3.2.0","1");
INSERT INTO #__postinstall_messages VALUES("5","700","COM_CPANEL_MSG_ROBOTS_TITLE","COM_CPANEL_MSG_ROBOTS_BODY","","com_cpanel","1","message","","","","","3.4.0","1");
INSERT INTO #__postinstall_messages VALUES("6","700","COM_CPANEL_MSG_LANGUAGEACCESS340_TITLE","COM_CPANEL_MSG_LANGUAGEACCESS340_BODY","","com_cpanel","1","message","","","admin://components/com_admin/postinstall/languageaccess340.php","admin_postinstall_languageaccess340_condition","3.4.1","1");
INSERT INTO #__postinstall_messages VALUES("7","700","COM_CPANEL_MSG_STATS_COLLECTION_TITLE","COM_CPANEL_MSG_STATS_COLLECTION_BODY","","com_cpanel","1","message","","","admin://components/com_admin/postinstall/statscollection.php","admin_postinstall_statscollection_condition","3.5.0","1");
INSERT INTO #__postinstall_messages VALUES("8","700","PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME","PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_BODY","PLG_SYSTEM_UPDATENOTIFICATION_POSTINSTALL_UPDATECACHETIME_ACTION","plg_system_updatenotification","1","action","site://plugins/system/updatenotification/postinstall/updatecachetime.php","updatecachetime_postinstall_action","site://plugins/system/updatenotification/postinstall/updatecachetime.php","updatecachetime_postinstall_condition","3.6.3","1");
INSERT INTO #__postinstall_messages VALUES("9","700","COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_TITLE","COM_CPANEL_MSG_JOOMLA40_PRE_CHECKS_BODY","","com_cpanel","1","message","","","admin://components/com_admin/postinstall/joomla40checks.php","admin_postinstall_joomla40checks_condition","3.7.0","1");
INSERT INTO #__postinstall_messages VALUES("10","700","TPL_HATHOR_MESSAGE_POSTINSTALL_TITLE","TPL_HATHOR_MESSAGE_POSTINSTALL_BODY","TPL_HATHOR_MESSAGE_POSTINSTALL_ACTION","tpl_hathor","1","action","admin://templates/hathor/postinstall/hathormessage.php","hathormessage_postinstall_action","admin://templates/hathor/postinstall/hathormessage.php","hathormessage_postinstall_condition","3.7.0","1");
INSERT INTO #__postinstall_messages VALUES("11","700","PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_TITLE","PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_BODY","PLG_PLG_RECAPTCHA_VERSION_1_POSTINSTALL_ACTION","plg_captcha_recaptcha","1","action","site://plugins/captcha/recaptcha/postinstall/actions.php","recaptcha_postinstall_action","site://plugins/captcha/recaptcha/postinstall/actions.php","recaptcha_postinstall_condition","3.8.6","1");
INSERT INTO #__postinstall_messages VALUES("12","700","COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_TITLE","COM_CPANEL_MSG_UPDATEDEFAULTSETTINGS_BODY","","com_cpanel","1","message","","","admin://components/com_admin/postinstall/updatedefaultsettings.php","admin_postinstall_updatedefaultsettings_condition","3.8.8","1");
INSERT INTO #__postinstall_messages VALUES("13","700","COM_ACTIONLOGS_POSTINSTALL_TITLE","COM_ACTIONLOGS_POSTINSTALL_BODY","","com_actionlogs","1","message","","","","","3.9.0","1");
INSERT INTO #__postinstall_messages VALUES("14","700","COM_PRIVACY_POSTINSTALL_TITLE","COM_PRIVACY_POSTINSTALL_BODY","","com_privacy","1","message","","","","","3.9.0","1");



DROP TABLE IF EXISTS #__privacy_consents;

CREATE TABLE `#__privacy_consents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `state` int(10) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `remind` tinyint(4) NOT NULL DEFAULT '0',
  `token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__privacy_requests;

CREATE TABLE `#__privacy_requests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `requested_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `request_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `confirm_token_created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__redirect_links;

CREATE TABLE `#__redirect_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `old_url` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `new_url` varchar(2048) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referer` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL,
  `created_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `header` smallint(3) NOT NULL DEFAULT '301',
  PRIMARY KEY (`id`),
  KEY `idx_link_modifed` (`modified_date`),
  KEY `idx_old_url` (`old_url`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__schemas;

CREATE TABLE `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__schemas VALUES("700","3.9.10-2019-07-09");



DROP TABLE IF EXISTS #__session;

CREATE TABLE `#__session` (
  `session_id` varbinary(192) NOT NULL,
  `client_id` tinyint(3) unsigned DEFAULT NULL,
  `guest` tinyint(3) unsigned DEFAULT '1',
  `time` int(11) NOT NULL DEFAULT '0',
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `userid` int(11) DEFAULT '0',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`session_id`),
  KEY `userid` (`userid`),
  KEY `time` (`time`),
  KEY `client_id_guest` (`client_id`,`guest`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__session VALUES("hq22p6d3uuhinmm8rblhigvfpv","1","1","1573730936","joomla|s:736:\"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjE6e3M6OToiX19kZWZhdWx0IjtPOjg6InN0ZENsYXNzIjozOntzOjc6InNlc3Npb24iO086ODoic3RkQ2xhc3MiOjM6e3M6NzoiY291bnRlciI7aToxO3M6NToidGltZXIiO086ODoic3RkQ2xhc3MiOjM6e3M6NToic3RhcnQiO2k6MTU3MzczMDkzNjtzOjQ6Imxhc3QiO2k6MTU3MzczMDkzNjtzOjM6Im5vdyI7aToxNTczNzMwOTM2O31zOjU6InRva2VuIjtzOjMyOiJHVjJmNWl6QWd4S2xnczkwQVAyNHh4QjB4U24yZE9kOCI7fXM6ODoicmVnaXN0cnkiO086MjQ6Ikpvb21sYVxSZWdpc3RyeVxSZWdpc3RyeSI6Mzp7czo3OiIAKgBkYXRhIjtPOjg6InN0ZENsYXNzIjowOnt9czoxNDoiACoAaW5pdGlhbGl6ZWQiO2I6MDtzOjk6InNlcGFyYXRvciI7czoxOiIuIjt9czo0OiJ1c2VyIjtPOjIwOiJKb29tbGFcQ01TXFVzZXJcVXNlciI6MTp7czoyOiJpZCI7aTowO319fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fQ==\";","0","");
INSERT INTO #__session VALUES("puqnaijn2hcmeginun6s2if7nf","0","1","1573730917","joomla|s:736:\"TzoyNDoiSm9vbWxhXFJlZ2lzdHJ5XFJlZ2lzdHJ5IjozOntzOjc6IgAqAGRhdGEiO086ODoic3RkQ2xhc3MiOjE6e3M6OToiX19kZWZhdWx0IjtPOjg6InN0ZENsYXNzIjozOntzOjc6InNlc3Npb24iO086ODoic3RkQ2xhc3MiOjM6e3M6NzoiY291bnRlciI7aToxO3M6NToidGltZXIiO086ODoic3RkQ2xhc3MiOjM6e3M6NToic3RhcnQiO2k6MTU3MzczMDkxNztzOjQ6Imxhc3QiO2k6MTU3MzczMDkxNztzOjM6Im5vdyI7aToxNTczNzMwOTE3O31zOjU6InRva2VuIjtzOjMyOiJWNEU1STlaaGVycENMVzFpdGI5a1lzZ1BReHZSQUhXUyI7fXM6ODoicmVnaXN0cnkiO086MjQ6Ikpvb21sYVxSZWdpc3RyeVxSZWdpc3RyeSI6Mzp7czo3OiIAKgBkYXRhIjtPOjg6InN0ZENsYXNzIjowOnt9czoxNDoiACoAaW5pdGlhbGl6ZWQiO2I6MDtzOjk6InNlcGFyYXRvciI7czoxOiIuIjt9czo0OiJ1c2VyIjtPOjIwOiJKb29tbGFcQ01TXFVzZXJcVXNlciI6MTp7czoyOiJpZCI7aTowO319fXM6MTQ6IgAqAGluaXRpYWxpemVkIjtiOjA7czo5OiJzZXBhcmF0b3IiO3M6MToiLiI7fQ==\";","0","");



DROP TABLE IF EXISTS #__tags;

CREATE TABLE `#__tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_language` (`language`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_alias` (`alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__tags VALUES("1","0","0","5","0","","ROOT","root","","","1","0","0000-00-00 00:00:00","1","{}","","","","647","2011-01-01 00:00:01","","0","0000-00-00 00:00:00","","","0","*","1","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO #__tags VALUES("2","1","1","2","1","faq","faq","faq","","","1","0","0000-00-00 00:00:00","1","","","","","647","2013-05-10 11:33:40","","0","0000-00-00 00:00:00","","","0","*","1","0000-00-00 00:00:00","0000-00-00 00:00:00");
INSERT INTO #__tags VALUES("3","1","3","4","1","sample","sample","sample","","","1","0","0000-00-00 00:00:00","1","","","","","647","2013-05-10 11:33:40","","0","0000-00-00 00:00:00","","","1","*","1","0000-00-00 00:00:00","0000-00-00 00:00:00");



DROP TABLE IF EXISTS #__template_styles;

CREATE TABLE `#__template_styles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `home` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__template_styles VALUES("5","hathor","1","0","Hathor - Default","{\"showSiteName\":\"0\",\"colourChoice\":\"\",\"boldText\":\"0\"}");
INSERT INTO #__template_styles VALUES("16","hot_coffeine","0","1","hot_coffeine - Default","{\"templateWidth\":\"980\",\"columnLeftWidth\":\"200\",\"columnRightWidth\":\"200\",\"textDirection\":\"ltr\",\"templateStyle\":\"1\",\"background\":\"bg1\",\"backgroundColor\":\"#000000\",\"backgroundHeader\":\"4\",\"topMenuBg\":\"#000000\",\"menuEffect\":\"fadeIn(700)\",\"topMenuButton\":\"#222222\",\"topMenuHoverButton\":\"#FFFFFF\",\"topMenuText\":\"#FFFFFF\",\"topMenuHoverText\":\"#222222\",\"mainMenuText\":\"#FFFFFF\",\"mainMenuHoverText\":\"#CCCCCC\",\"mainMenuTextActive\":\"#000000\",\"bodyText\":\"#C9C9C9\",\"bodyLink\":\"#000000\",\"breadcrumbsText\":\"#FFFFFF\",\"componentHeadingText\":\"#FFFFFF\",\"headingText\":\"#FFFFFF\",\"headingHoverText\":\"#E4E37C\",\"columnFirstWord\":\"#E4E37C\",\"columnHeading\":\"#FFFFFF\",\"columnBg\":\"#000000\",\"columnText\":\"#FFFFFF\",\"columnLink\":\"#000000\",\"columnBg2\":\"#5F3E0B\",\"columnText2\":\"#FFFFFF\",\"columnLink2\":\"#FFFFFF\",\"bottomBgColor\":\"#121212\",\"bottomTextColor\":\"#FFFFFF\",\"bottomLinkColor\":\"#FFFFFF\",\"footerTextColor\":\"#000000\",\"panelBg\":\"#51A0B1\",\"panelHeadings\":\"#FFFFFF\",\"panelBorder\":\"#FFFFFF\",\"panelText\":\"#DDDDDD\",\"imageReflectionLoad\":\"1\",\"fontResizeLoad\":\"1\",\"lightboxLoad\":\"1\"}");
INSERT INTO #__template_styles VALUES("17","protostar","0","0","protostar - Default","{\"templateColor\":\"\",\"logoFile\":\"\",\"googleFont\":\"1\",\"googleFontName\":\"Open+Sans\",\"fluidContainer\":\"0\"}");
INSERT INTO #__template_styles VALUES("18","isis","1","1","isis - Default","{\"templateColor\":\"\",\"logoFile\":\"\"}");
INSERT INTO #__template_styles VALUES("19","beez3","0","0","beez3 - Default","{\"wrapperSmall\":53,\"wrapperLarge\":72,\"logo\":\"\",\"sitetitle\":\"\",\"sitedescription\":\"\",\"navposition\":\"center\",\"bootstrap\":\"\",\"templatecolor\":\"nature\",\"headerImage\":\"\",\"backgroundcolor\":\"#eee\"}");



DROP TABLE IF EXISTS #__ucm_base;

CREATE TABLE `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__ucm_base VALUES("1","20","1","0");



DROP TABLE IF EXISTS #__ucm_content;

CREATE TABLE `#__ucm_content` (
  `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_state` tinyint(1) NOT NULL DEFAULT '0',
  `core_checked_out_time` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_checked_out_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_access` int(10) unsigned NOT NULL DEFAULT '0',
  `core_params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_featured` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `core_metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_content_item_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `core_images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_urls` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `core_version` int(10) unsigned NOT NULL DEFAULT '1',
  `core_ordering` int(11) NOT NULL DEFAULT '0',
  `core_metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_catid` int(10) unsigned NOT NULL DEFAULT '0',
  `core_xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_language` (`core_language`),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_content_type` (`core_type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';

INSERT INTO #__ucm_content VALUES("1","com_content.article","FAQ Article 1","faq-article-1","<p>Duis autem vel eum iriure dolor in hendrerit in vulputate velit esse molestie consequat, vel illum dolore eu feugiat nulla facilisis. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet. Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</p>
\n","1","","0","1","{\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}","0","{\"tags\":[2,3],\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}","647","","2011-01-18 11:06:41","0","2013-05-10 11:33:40","*","2011-01-18 11:06:41","0000-00-00 00:00:00","20","66","","","34","2","2","","","12","","1");



DROP TABLE IF EXISTS #__ucm_history;

CREATE TABLE `#__ucm_history` (
  `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ucm_item_id` int(10) unsigned NOT NULL,
  `ucm_type_id` int(10) unsigned NOT NULL,
  `version_note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `character_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0=auto delete; 1=keep',
  PRIMARY KEY (`version_id`),
  KEY `idx_ucm_item_id` (`ucm_type_id`,`ucm_item_id`),
  KEY `idx_save_date` (`save_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__update_sites;

CREATE TABLE `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `location` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) DEFAULT '0',
  `last_check_timestamp` bigint(20) DEFAULT '0',
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';

INSERT INTO #__update_sites VALUES("1","Joomla! Core","collection","https://update.joomla.org/core/sts/list_sts.xml","1","1573730848","");
INSERT INTO #__update_sites VALUES("3","Accredited Joomla! Translations","collection","https://update.joomla.org/language/translationlist_3.xml","1","1573730825","");
INSERT INTO #__update_sites VALUES("4","Joomla! Update Component Update Site","extension","https://update.joomla.org/core/extensions/com_joomlaupdate.xml","1","1573730873","");



DROP TABLE IF EXISTS #__update_sites_extensions;

CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT '0',
  `extension_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';

INSERT INTO #__update_sites_extensions VALUES("1","700");
INSERT INTO #__update_sites_extensions VALUES("3","802");
INSERT INTO #__update_sites_extensions VALUES("4","28");



DROP TABLE IF EXISTS #__updates;

CREATE TABLE `#__updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT '0',
  `extension_id` int(11) DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `folder` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `client_id` tinyint(3) DEFAULT '0',
  `version` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailsurl` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `infourl` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=124 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';

INSERT INTO #__updates VALUES("1","3","0","Armenian","","pkg_hy-AM","package","","0","3.4.4.1","","https://update.joomla.org/language/details3/hy-AM_details.xml","","");
INSERT INTO #__updates VALUES("2","3","0","Malay","","pkg_ms-MY","package","","0","3.4.1.2","","https://update.joomla.org/language/details3/ms-MY_details.xml","","");
INSERT INTO #__updates VALUES("3","3","0","Romanian","","pkg_ro-RO","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/ro-RO_details.xml","","");
INSERT INTO #__updates VALUES("4","3","0","Flemish","","pkg_nl-BE","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/nl-BE_details.xml","","");
INSERT INTO #__updates VALUES("5","3","0","Chinese Traditional","","pkg_zh-TW","package","","0","3.8.0.1","","https://update.joomla.org/language/details3/zh-TW_details.xml","","");
INSERT INTO #__updates VALUES("6","3","0","French","","pkg_fr-FR","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/fr-FR_details.xml","","");
INSERT INTO #__updates VALUES("7","3","0","Galician","","pkg_gl-ES","package","","0","3.3.1.2","","https://update.joomla.org/language/details3/gl-ES_details.xml","","");
INSERT INTO #__updates VALUES("8","3","0","Georgian","","pkg_ka-GE","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/ka-GE_details.xml","","");
INSERT INTO #__updates VALUES("9","3","0","Greek","","pkg_el-GR","package","","0","3.9.4.3","","https://update.joomla.org/language/details3/el-GR_details.xml","","");
INSERT INTO #__updates VALUES("10","3","0","Japanese","","pkg_ja-JP","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/ja-JP_details.xml","","");
INSERT INTO #__updates VALUES("11","3","0","Hebrew","","pkg_he-IL","package","","0","3.1.1.2","","https://update.joomla.org/language/details3/he-IL_details.xml","","");
INSERT INTO #__updates VALUES("12","3","0","Bengali","","pkg_bn-BD","package","","0","3.8.10.1","","https://update.joomla.org/language/details3/bn-BD_details.xml","","");
INSERT INTO #__updates VALUES("13","3","0","Hungarian","","pkg_hu-HU","package","","0","3.9.0.3","","https://update.joomla.org/language/details3/hu-HU_details.xml","","");
INSERT INTO #__updates VALUES("14","3","0","Afrikaans","","pkg_af-ZA","package","","0","3.9.0.1","","https://update.joomla.org/language/details3/af-ZA_details.xml","","");
INSERT INTO #__updates VALUES("15","3","0","Arabic Unitag","","pkg_ar-AA","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/ar-AA_details.xml","","");
INSERT INTO #__updates VALUES("16","3","0","Belarusian","","pkg_be-BY","package","","0","3.2.1.2","","https://update.joomla.org/language/details3/be-BY_details.xml","","");
INSERT INTO #__updates VALUES("17","3","0","Bulgarian","","pkg_bg-BG","package","","0","3.6.5.2","","https://update.joomla.org/language/details3/bg-BG_details.xml","","");
INSERT INTO #__updates VALUES("18","3","0","Catalan","","pkg_ca-ES","package","","0","3.8.11.1","","https://update.joomla.org/language/details3/ca-ES_details.xml","","");
INSERT INTO #__updates VALUES("19","3","0","Chinese Simplified","","pkg_zh-CN","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/zh-CN_details.xml","","");
INSERT INTO #__updates VALUES("20","3","0","Croatian","","pkg_hr-HR","package","","0","3.8.5.1","","https://update.joomla.org/language/details3/hr-HR_details.xml","","");
INSERT INTO #__updates VALUES("21","3","0","Czech","","pkg_cs-CZ","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/cs-CZ_details.xml","","");
INSERT INTO #__updates VALUES("22","3","0","Danish","","pkg_da-DK","package","","0","3.9.4.2","","https://update.joomla.org/language/details3/da-DK_details.xml","","");
INSERT INTO #__updates VALUES("23","3","0","Dutch","","pkg_nl-NL","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/nl-NL_details.xml","","");
INSERT INTO #__updates VALUES("24","3","0","Esperanto","","pkg_eo-XX","package","","0","3.8.11.1","","https://update.joomla.org/language/details3/eo-XX_details.xml","","");
INSERT INTO #__updates VALUES("25","3","0","Estonian","","pkg_et-EE","package","","0","3.8.10.1","","https://update.joomla.org/language/details3/et-EE_details.xml","","");
INSERT INTO #__updates VALUES("26","3","0","Italian","","pkg_it-IT","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/it-IT_details.xml","","");
INSERT INTO #__updates VALUES("27","3","0","Khmer","","pkg_km-KH","package","","0","3.4.5.1","","https://update.joomla.org/language/details3/km-KH_details.xml","","");
INSERT INTO #__updates VALUES("28","3","0","Korean","","pkg_ko-KR","package","","0","3.8.9.1","","https://update.joomla.org/language/details3/ko-KR_details.xml","","");
INSERT INTO #__updates VALUES("29","3","0","Latvian","","pkg_lv-LV","package","","0","3.7.3.1","","https://update.joomla.org/language/details3/lv-LV_details.xml","","");
INSERT INTO #__updates VALUES("30","3","0","Lithuanian","","pkg_lt-LT","package","","0","3.8.10.1","","https://update.joomla.org/language/details3/lt-LT_details.xml","","");
INSERT INTO #__updates VALUES("31","3","0","Macedonian","","pkg_mk-MK","package","","0","3.6.5.1","","https://update.joomla.org/language/details3/mk-MK_details.xml","","");
INSERT INTO #__updates VALUES("32","3","0","Norwegian Bokmal","","pkg_nb-NO","package","","0","3.8.11.1","","https://update.joomla.org/language/details3/nb-NO_details.xml","","");
INSERT INTO #__updates VALUES("33","3","0","Norwegian Nynorsk","","pkg_nn-NO","package","","0","3.4.2.1","","https://update.joomla.org/language/details3/nn-NO_details.xml","","");
INSERT INTO #__updates VALUES("34","3","0","Persian","","pkg_fa-IR","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/fa-IR_details.xml","","");
INSERT INTO #__updates VALUES("35","3","0","Polish","","pkg_pl-PL","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/pl-PL_details.xml","","");
INSERT INTO #__updates VALUES("36","3","0","Portuguese","","pkg_pt-PT","package","","0","3.9.3.1","","https://update.joomla.org/language/details3/pt-PT_details.xml","","");
INSERT INTO #__updates VALUES("37","3","0","Russian","","pkg_ru-RU","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/ru-RU_details.xml","","");
INSERT INTO #__updates VALUES("38","3","0","English AU","","pkg_en-AU","package","","0","3.9.3.1","","https://update.joomla.org/language/details3/en-AU_details.xml","","");
INSERT INTO #__updates VALUES("39","3","0","Slovak","","pkg_sk-SK","package","","0","3.9.4.3","","https://update.joomla.org/language/details3/sk-SK_details.xml","","");
INSERT INTO #__updates VALUES("40","3","0","English US","","pkg_en-US","package","","0","3.9.3.1","","https://update.joomla.org/language/details3/en-US_details.xml","","");
INSERT INTO #__updates VALUES("41","3","0","Swedish","","pkg_sv-SE","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/sv-SE_details.xml","","");
INSERT INTO #__updates VALUES("42","3","0","Syriac","","pkg_sy-IQ","package","","0","3.4.5.1","","https://update.joomla.org/language/details3/sy-IQ_details.xml","","");
INSERT INTO #__updates VALUES("43","3","0","Tamil","","pkg_ta-IN","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/ta-IN_details.xml","","");
INSERT INTO #__updates VALUES("44","3","0","Thai","","pkg_th-TH","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/th-TH_details.xml","","");
INSERT INTO #__updates VALUES("45","3","0","Turkish","","pkg_tr-TR","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/tr-TR_details.xml","","");
INSERT INTO #__updates VALUES("46","3","0","Ukrainian","","pkg_uk-UA","package","","0","3.7.1.1","","https://update.joomla.org/language/details3/uk-UA_details.xml","","");
INSERT INTO #__updates VALUES("47","3","0","Uyghur","","pkg_ug-CN","package","","0","3.7.5.1","","https://update.joomla.org/language/details3/ug-CN_details.xml","","");
INSERT INTO #__updates VALUES("48","3","0","Albanian","","pkg_sq-AL","package","","0","3.1.1.2","","https://update.joomla.org/language/details3/sq-AL_details.xml","","");
INSERT INTO #__updates VALUES("49","3","0","Basque","","pkg_eu-ES","package","","0","3.7.5.1","","https://update.joomla.org/language/details3/eu-ES_details.xml","","");
INSERT INTO #__updates VALUES("50","3","0","Hindi","","pkg_hi-IN","package","","0","3.3.6.2","","https://update.joomla.org/language/details3/hi-IN_details.xml","","");
INSERT INTO #__updates VALUES("51","3","0","German DE","","pkg_de-DE","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/de-DE_details.xml","","");
INSERT INTO #__updates VALUES("52","3","0","Portuguese Brazil","","pkg_pt-BR","package","","0","3.9.4.2","","https://update.joomla.org/language/details3/pt-BR_details.xml","","");
INSERT INTO #__updates VALUES("53","3","0","Serbian Latin","","pkg_sr-YU","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/sr-YU_details.xml","","");
INSERT INTO #__updates VALUES("54","3","0","Spanish","","pkg_es-ES","package","","0","3.9.1.1","","https://update.joomla.org/language/details3/es-ES_details.xml","","");
INSERT INTO #__updates VALUES("55","3","0","Bosnian","","pkg_bs-BA","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/bs-BA_details.xml","","");
INSERT INTO #__updates VALUES("56","3","0","Serbian Cyrillic","","pkg_sr-RS","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/sr-RS_details.xml","","");
INSERT INTO #__updates VALUES("57","3","0","Vietnamese","","pkg_vi-VN","package","","0","3.2.1.2","","https://update.joomla.org/language/details3/vi-VN_details.xml","","");
INSERT INTO #__updates VALUES("58","3","0","Bahasa Indonesia","","pkg_id-ID","package","","0","3.6.2.1","","https://update.joomla.org/language/details3/id-ID_details.xml","","");
INSERT INTO #__updates VALUES("59","3","0","Finnish","","pkg_fi-FI","package","","0","3.9.4.2","","https://update.joomla.org/language/details3/fi-FI_details.xml","","");
INSERT INTO #__updates VALUES("60","3","0","Swahili","","pkg_sw-KE","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/sw-KE_details.xml","","");
INSERT INTO #__updates VALUES("61","3","0","Montenegrin","","pkg_srp-ME","package","","0","3.3.1.2","","https://update.joomla.org/language/details3/srp-ME_details.xml","","");
INSERT INTO #__updates VALUES("62","3","0","English CA","","pkg_en-CA","package","","0","3.9.3.1","","https://update.joomla.org/language/details3/en-CA_details.xml","","");
INSERT INTO #__updates VALUES("63","3","0","French CA","","pkg_fr-CA","package","","0","3.6.5.1","","https://update.joomla.org/language/details3/fr-CA_details.xml","","");
INSERT INTO #__updates VALUES("64","3","0","Welsh","","pkg_cy-GB","package","","0","3.9.2.1","","https://update.joomla.org/language/details3/cy-GB_details.xml","","");
INSERT INTO #__updates VALUES("66","3","0","Sinhala","","pkg_si-LK","package","","0","3.3.1.2","","https://update.joomla.org/language/details3/si-LK_details.xml","","");
INSERT INTO #__updates VALUES("67","3","0","Dari Persian","","pkg_prs-AF","package","","0","3.4.4.2","","https://update.joomla.org/language/details3/prs-AF_details.xml","","");
INSERT INTO #__updates VALUES("68","3","0","Turkmen","","pkg_tk-TM","package","","0","3.5.0.2","","https://update.joomla.org/language/details3/tk-TM_details.xml","","");
INSERT INTO #__updates VALUES("69","3","0","Irish","","pkg_ga-IE","package","","0","3.8.13.1","","https://update.joomla.org/language/details3/ga-IE_details.xml","","");
INSERT INTO #__updates VALUES("70","3","0","Dzongkha","","pkg_dz-BT","package","","0","3.6.2.1","","https://update.joomla.org/language/details3/dz-BT_details.xml","","");
INSERT INTO #__updates VALUES("71","3","0","Slovenian","","pkg_sl-SI","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/sl-SI_details.xml","","");
INSERT INTO #__updates VALUES("72","3","0","Spanish CO","","pkg_es-CO","package","","0","3.9.4.2","","https://update.joomla.org/language/details3/es-CO_details.xml","","");
INSERT INTO #__updates VALUES("73","3","0","German CH","","pkg_de-CH","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/de-CH_details.xml","","");
INSERT INTO #__updates VALUES("74","3","0","German AT","","pkg_de-AT","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/de-AT_details.xml","","");
INSERT INTO #__updates VALUES("75","3","0","German LI","","pkg_de-LI","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/de-LI_details.xml","","");
INSERT INTO #__updates VALUES("76","3","0","German LU","","pkg_de-LU","package","","0","3.9.4.1","","https://update.joomla.org/language/details3/de-LU_details.xml","","");
INSERT INTO #__updates VALUES("77","3","0","English NZ","","pkg_en-NZ","package","","0","3.9.3.1","","https://update.joomla.org/language/details3/en-NZ_details.xml","","");
INSERT INTO #__updates VALUES("79","3","0","Romanian","","pkg_ro-RO","package","","0","3.9.7.1","","https://update.joomla.org/language/details3/ro-RO_details.xml","","");
INSERT INTO #__updates VALUES("80","3","0","Flemish","","pkg_nl-BE","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/nl-BE_details.xml","","");
INSERT INTO #__updates VALUES("81","3","0","French","","pkg_fr-FR","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/fr-FR_details.xml","","");
INSERT INTO #__updates VALUES("82","3","0","Georgian","","pkg_ka-GE","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/ka-GE_details.xml","","");
INSERT INTO #__updates VALUES("83","3","0","Greek","","pkg_el-GR","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/el-GR_details.xml","","");
INSERT INTO #__updates VALUES("84","3","0","Japanese","","pkg_ja-JP","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/ja-JP_details.xml","","");
INSERT INTO #__updates VALUES("85","3","0","Hungarian","","pkg_hu-HU","package","","0","3.9.12.1","","https://update.joomla.org/language/details3/hu-HU_details.xml","","");
INSERT INTO #__updates VALUES("86","3","0","Afrikaans","","pkg_af-ZA","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/af-ZA_details.xml","","");
INSERT INTO #__updates VALUES("87","3","0","Arabic Unitag","","pkg_ar-AA","package","","0","3.9.10.1","","https://update.joomla.org/language/details3/ar-AA_details.xml","","");
INSERT INTO #__updates VALUES("88","3","0","Catalan","","pkg_ca-ES","package","","0","3.9.11.2","","https://update.joomla.org/language/details3/ca-ES_details.xml","","");
INSERT INTO #__updates VALUES("89","3","0","Chinese Simplified","","pkg_zh-CN","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/zh-CN_details.xml","","");
INSERT INTO #__updates VALUES("90","3","0","Croatian","","pkg_hr-HR","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/hr-HR_details.xml","","");
INSERT INTO #__updates VALUES("91","3","0","Czech","","pkg_cs-CZ","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/cs-CZ_details.xml","","");
INSERT INTO #__updates VALUES("92","3","0","Danish","","pkg_da-DK","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/da-DK_details.xml","","");
INSERT INTO #__updates VALUES("93","3","0","Dutch","","pkg_nl-NL","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/nl-NL_details.xml","","");
INSERT INTO #__updates VALUES("94","3","0","Italian","","pkg_it-IT","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/it-IT_details.xml","","");
INSERT INTO #__updates VALUES("95","3","0","Lithuanian","","pkg_lt-LT","package","","0","3.9.6.1","","https://update.joomla.org/language/details3/lt-LT_details.xml","","");
INSERT INTO #__updates VALUES("96","3","0","Persian","","pkg_fa-IR","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/fa-IR_details.xml","","");
INSERT INTO #__updates VALUES("97","3","0","Polish","","pkg_pl-PL","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/pl-PL_details.xml","","");
INSERT INTO #__updates VALUES("98","3","0","Portuguese","","pkg_pt-PT","package","","0","3.9.5.1","","https://update.joomla.org/language/details3/pt-PT_details.xml","","");
INSERT INTO #__updates VALUES("99","3","0","Russian","","pkg_ru-RU","package","","0","3.9.12.1","","https://update.joomla.org/language/details3/ru-RU_details.xml","","");
INSERT INTO #__updates VALUES("100","3","0","English AU","","pkg_en-AU","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/en-AU_details.xml","","");
INSERT INTO #__updates VALUES("101","3","0","Slovak","","pkg_sk-SK","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/sk-SK_details.xml","","");
INSERT INTO #__updates VALUES("102","3","0","English US","","pkg_en-US","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/en-US_details.xml","","");
INSERT INTO #__updates VALUES("103","3","0","Swedish","","pkg_sv-SE","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/sv-SE_details.xml","","");
INSERT INTO #__updates VALUES("104","3","0","Tamil","","pkg_ta-IN","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/ta-IN_details.xml","","");
INSERT INTO #__updates VALUES("105","3","0","Thai","","pkg_th-TH","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/th-TH_details.xml","","");
INSERT INTO #__updates VALUES("106","3","0","German DE","","pkg_de-DE","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/de-DE_details.xml","","");
INSERT INTO #__updates VALUES("107","3","0","Portuguese Brazil","","pkg_pt-BR","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/pt-BR_details.xml","","");
INSERT INTO #__updates VALUES("108","3","0","Serbian Latin","","pkg_sr-YU","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/sr-YU_details.xml","","");
INSERT INTO #__updates VALUES("109","3","0","Spanish","","pkg_es-ES","package","","0","3.9.11.1","","https://update.joomla.org/language/details3/es-ES_details.xml","","");
INSERT INTO #__updates VALUES("110","3","0","Bosnian","","pkg_bs-BA","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/bs-BA_details.xml","","");
INSERT INTO #__updates VALUES("111","3","0","Serbian Cyrillic","","pkg_sr-RS","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/sr-RS_details.xml","","");
INSERT INTO #__updates VALUES("112","3","0","Finnish","","pkg_fi-FI","package","","0","3.9.12.1","","https://update.joomla.org/language/details3/fi-FI_details.xml","","");
INSERT INTO #__updates VALUES("113","3","0","Swahili","","pkg_sw-KE","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/sw-KE_details.xml","","");
INSERT INTO #__updates VALUES("114","3","0","English CA","","pkg_en-CA","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/en-CA_details.xml","","");
INSERT INTO #__updates VALUES("115","3","0","Welsh","","pkg_cy-GB","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/cy-GB_details.xml","","");
INSERT INTO #__updates VALUES("116","3","0","Slovenian","","pkg_sl-SI","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/sl-SI_details.xml","","");
INSERT INTO #__updates VALUES("117","3","0","Spanish CO","","pkg_es-CO","package","","0","3.9.10.1","","https://update.joomla.org/language/details3/es-CO_details.xml","","");
INSERT INTO #__updates VALUES("118","3","0","German CH","","pkg_de-CH","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/de-CH_details.xml","","");
INSERT INTO #__updates VALUES("119","3","0","German AT","","pkg_de-AT","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/de-AT_details.xml","","");
INSERT INTO #__updates VALUES("120","3","0","German LI","","pkg_de-LI","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/de-LI_details.xml","","");
INSERT INTO #__updates VALUES("121","3","0","German LU","","pkg_de-LU","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/de-LU_details.xml","","");
INSERT INTO #__updates VALUES("122","3","0","English NZ","","pkg_en-NZ","package","","0","3.9.13.1","","https://update.joomla.org/language/details3/en-NZ_details.xml","","");
INSERT INTO #__updates VALUES("123","3","0","Kazakh","","pkg_kk-KZ","package","","0","3.9.12.1","","https://update.joomla.org/language/details3/kk-KZ_details.xml","","");



DROP TABLE IF EXISTS #__user_keys;

CREATE TABLE `#__user_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `series` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invalid` tinyint(4) NOT NULL,
  `time` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uastring` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__user_notes;

CREATE TABLE `#__user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `review_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS #__user_profiles;

CREATE TABLE `#__user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Simple user profile storage table';




DROP TABLE IF EXISTS #__user_usergroup_map;

CREATE TABLE `#__user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__user_usergroup_map VALUES("647","8");



DROP TABLE IF EXISTS #__usergroups;

CREATE TABLE `#__usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__usergroups VALUES("1","0","1","18","Public");
INSERT INTO #__usergroups VALUES("2","1","8","15","Registered");
INSERT INTO #__usergroups VALUES("3","2","9","14","Author");
INSERT INTO #__usergroups VALUES("4","3","10","13","Editor");
INSERT INTO #__usergroups VALUES("5","4","11","12","Publisher");
INSERT INTO #__usergroups VALUES("6","1","4","7","Manager");
INSERT INTO #__usergroups VALUES("7","6","5","6","Administrator");
INSERT INTO #__usergroups VALUES("8","1","16","17","Super Users");
INSERT INTO #__usergroups VALUES("9","1","2","3","Guest");



DROP TABLE IF EXISTS #__users;

CREATE TABLE `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT '0',
  `sendEmail` tinyint(4) DEFAULT '0',
  `registerDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastvisitDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activation` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastResetTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Date of last password reset',
  `resetCount` int(11) NOT NULL DEFAULT '0' COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Require user to reset password on next login',
  PRIMARY KEY (`id`),
  KEY `idx_block` (`block`),
  KEY `username` (`username`),
  KEY `email` (`email`),
  KEY `idx_name` (`name`(100))
) ENGINE=InnoDB AUTO_INCREMENT=648 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__users VALUES("647","Super User","admin","noreply@coffeinetemplate.com","$2y$10$dtdZQYqdNQRlXw.zpBXrSOVNMUnMowSCM7FyDVmwn47j0K8ugAUgu","0","1","2015-10-25 15:19:53","2019-11-14 11:28:56","0","","0000-00-00 00:00:00","0","","","0");



DROP TABLE IF EXISTS #__utf8_conversion;

CREATE TABLE `#__utf8_conversion` (
  `converted` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__utf8_conversion VALUES("2");



DROP TABLE IF EXISTS #__viewlevels;

CREATE TABLE `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO #__viewlevels VALUES("1","Public","0","[1]");
INSERT INTO #__viewlevels VALUES("2","Registered","1","[6,2,8]");
INSERT INTO #__viewlevels VALUES("3","Special","2","[6,3,8]");
INSERT INTO #__viewlevels VALUES("5","Guest","0","[9]");
INSERT INTO #__viewlevels VALUES("6","Super Users","0","[8]");



DROP TABLE IF EXISTS #__weblinks;

CREATE TABLE `#__weblinks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(250) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `url` varchar(250) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `hits` int(11) NOT NULL DEFAULT '0',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  `params` text NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if link is featured.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `images` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO #__weblinks VALUES("1","6","Joomla!","joomla","http://www.joomla.org","Home of Joomla!","0","1","0","0000-00-00 00:00:00","1","1","{\"target\":\"\",\"width\":\"\",\"height\":\"\",\"count_clicks\":\"\"}","*","2011-01-18 11:32:56","42","","0000-00-00 00:00:00","0","","","","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","1","");
INSERT INTO #__weblinks VALUES("2","6","Joomla! - Forums","joomla-forums","http://forum.joomla.org","Joomla! - Forums","0","1","0","0000-00-00 00:00:00","2","1","{\"target\":\"\",\"width\":\"\",\"height\":\"\",\"count_clicks\":\"\"}","*","2011-01-18 11:33:17","42","","0000-00-00 00:00:00","0","","","","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","1","");
INSERT INTO #__weblinks VALUES("3","6","OpenSourceMatters","opensourcematters","http://www.opensourcematters.org","Home of OSM","0","1","0","0000-00-00 00:00:00","3","1","{\"target\":\"\",\"width\":\"\",\"height\":\"\",\"count_clicks\":\"\"}","*","2011-01-18 11:33:40","42","","0000-00-00 00:00:00","0","","","","0","","0000-00-00 00:00:00","0000-00-00 00:00:00","1","");



