<?php
/*------------------------------------------------------------------------
# "Hot Zoomer" Joomla module
# Copyright (C) 2011 ArhiNet d.o.o. All Rights Reserved.
# License: http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
# Author: HotJoomlaTemplates.com
# Website: http://www.hotjoomlatemplates.com
-------------------------------------------------------------------------*/

defined('JPATH_BASE') or die;

jimport('joomla.form.formfield');

/**
 * Form Field class for the Joomla Framework.
 *
 * @package		Joomla.Framework
 * @subpackage	Form
 * @since		1.6
 */
class JFormFieldzeditor extends JFormField
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	protected $type = 'zeditor';

	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
		// Initialize some field attributes.
		$size		= $this->element['size'] ? ' size="'.(int) $this->element['size'].'"' : '';
		$maxLength	= $this->element['maxlength'] ? ' maxlength="'.(int) $this->element['maxlength'].'"' : '';
		$id			= $this->element['id'] ? ' id="'.(string) $this->element['id'].'"' : '';
		$previewid	= $this->element['previewid'] ? ' id="'.(string) $this->element['previewid'].'"' : '';
		$readonly	= ((string) $this->element['readonly'] == 'true') ? ' readonly="readonly"' : '';
		$disabled	= ((string) $this->element['disabled'] == 'true') ? ' disabled="disabled"' : '';

		// Initialize JavaScript field attributes.
		$onchange	= $this->element['onchange'] ? ' onchange="'.(string) $this->element['onchange'].'"' : '';

		$html = array();
		$class = $this->element['class'] ? (string) $this->element['class'] : 'zeditor';

		$value = htmlspecialchars(html_entity_decode($this->value, ENT_QUOTES), ENT_QUOTES);
  
		
		ob_start();
        //---------------------------------------------- 
        ?> 
<INPUT type="hidden" name="<?php echo $this->name; ?>" id="<?php echo $this->id; ?>" class="<?php echo $class; ?>"  value="<?php echo htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8'); ?>" /><button onclick="ShowZoomerModal();return false;" > <?php echo JText::sprintf("Edit Images");?> </button>

<div id="zoomerEditorDialog" style="display:none;">
 <table cellpadding="0" cellspacing="0" style="width:100%;" >
 <tr>
  

 

 <td  style="vertical-align:top;border:1px Dotted Silver; width:320px;">
  <span id="zoomerNoLoadMessage" style="display:block;"><?php echo JText::sprintf("Select the image to change it's animation properties");?> </span> 
  <div style="height:100%;width:320px;">
  
  
  <table id="zoomerUserEditTable" style="display:none;width:300px;">
    
    <tr><td colspan="3"><?php echo JText::sprintf("Image URL")?><br/> <input style="width:300px;" id="k_src" type="text" value="" />  </td></tr>
	<tr><td colspan="3"><?php echo JText::sprintf("Title");?><br/><input style="width:300px;" id="k_title" type="text" value="" /> </td> </tr>
	<tr><td colspan="3"><?php echo JText::sprintf("Link");?><br/><input  style="width:300px;" id="k_link" type="text" value="" /> </td> </tr>
	<tr><td><?php echo JText::sprintf("Width/Height(px)");?>:</td><td><input id="k_width" class="numeric" style="width:65px;" type="text" value="0" />  /</td><td><input id="k_height" class="numeric" style="width:65px;float:right;" type="text" value="0" /></td></tr>
    <tr><td><?php echo JText::sprintf("Total/Anim. duration (ms)");?>:</td><td><input id="k_item_duration" style="width:65px;" class="numeric" type="text" value="8000" />  /</td><td><input id="k_animation_duration" style="width:65px;float:right;" class="numeric" type="text" value="4000" /></td></tr>	
	
	<tr><td><?php echo JText::sprintf("Animation easing");?>:</td><td colspan="2">
	 <select id="k_animationEasing">
	     <optgroup label="Basic"> 
		  <option value="linear">linear</option>
		  <option value="swing">swing</option>
		 </optgroup>
         <optgroup label="jQuery-ui required">		 
		  <option value="easeInQuad">easeInQuad</option>
		  <option value="easeOutQuad">easeOutQuad</option>
		  <option value="easeInOutQuad">easeInOutQuad</option>
		  <option value="easeInCubic">easeInCubic</option>
		  <option value="easeOutCubic">easeOutCubic</option>
		  <option value="easeInOutCubic">easeInOutCubic</option>
		  <option value="easeInQuart">easeInQuart</option>
		  <option value="easeOutQuart">easeOutQuart</option>
		  <option value="easeInOutQuart">easeInOutQuart</option>
		  <option value="easeInQuint">easeInQuint</option>
		  <option value="easeOutQuint">easeOutQuint</option>
		  <option value="easeInOutQuint">easeInOutQuint</option>
		  <option value="easeInSine">easeInSine</option>
		  <option value="easeOutSine">easeOutSine</option>
		  <option value="easeInOutSine">easeInOutSine</option>
		  <option value="easeInExpo">easeInExpo</option>
		  <option value="easeOutExpo">easeOutExpo</option>
		  <option value="easeInOutExpo">easeInOutExpo</option>
		  <option value="easeInCirc">easeInCirc</option>
		  <option value="easeOutCirc">easeOutCirc</option>
		  <option value="easeInOutCirc">easeInOutCirc</option>
		  <option value="easeInElastic">easeInElastic</option>
		  <option value="easeOutElastic">easeOutElastic</option>
		  <option value="easeInOutElastic">easeInOutElastic</option>
		  <option value="easeInBack">easeInBack</option>
		  <option value="easeOutBack">easeOutBack</option>
		  <option value="easeInOutBack">easeInOutBack</option>
		  <option value="easeInBounce">easeInBounce</option>
		  <option value="easeOutBounce">easeOutBounce</option>
		  <option value="easeInOutBounce">easeInOutBounce</option>
		</optgroup> 
	 </select>
	</td></tr>
	<tr><td><?php echo JText::sprintf("Anim. From(x,y,zoom)");?>:</td><td colspan="2" ><input id="k_from"  type="text" style="width:170px;color:Blue;border:1px Solid Blue;" value="0,0,1" /></td></tr>
	
	<tr><td><?php echo JText::sprintf("Anim. To(x,y,zoom)");?>:</td><td  colspan="2" ><input id="k_to"  type="text" style="width:170px;float:right;color:Red;border:1px Solid Red;" value="1,1,1" /></td></tr>
	
	<tr>
	 <td  colspan="3" > 
	    <span> <?php echo JText::sprintf("Use blue and red square to set values visually:");?> </span>
	    <div id="zoomerPerViewContainer" style="border:1px Solid Black;padding:0;">
		   <div id="zoomerVisualMesureFrom" style="position:absolute;padding:0;margin:0;" >
		     <div id="zoomerVisualMesureFromResizer" style="margin:0;border:2px Solid Blue;"></div>
		   </div>
		   <div id="zoomerVisualMesureTo" style="position:absolute;padding:0;margin:0;"  >
		    <div id="zoomerVisualMesureToResizer" style="margin:0;border:2px Solid Red;"></div>
		   </div>
		   <img id="zoomerPreviewImage" onload="zoomerImageMeasure()" src="" style="margin:0;" width="300px" alt="When you edit image url image will display(if url is correct!)"/>
	    </div>
	 </td>
	</tr>
  </table>
  
  </div>
 </td>
 
 
 <td  style="width:30px;text-align:center;">
<button id="zoomer_cmdUP"  >&uarr;</button>
<button id="zoomer_cmdDown" >&darr;</button>
</td>
 
  <td style="vertical-align:top;width:400px;" >
	 <div id="zoomerEditorToolbar" class="ui-widget-header" style="width:320px;height:33px;" >  
	   <button id="zoomer_cmdAdd" > <?php echo JText::sprintf("Add New Image");?> </button>
	   <button id="zoomer_cmdRemove" > <?php echo JText::sprintf("Remove");?> </button>
	 </div>
	 <div id="zoomerEditorListView" style="width:320px;height:450px;border:1px Dotted Silver;overflow-y:scroll;">
	   <table id="zoomerEditorList" style="">
	    <tr  class="ui-widget-header">
		<th style="width:20px;">
		  <?php echo JText::sprintf("No.");?>
		</th>
		<th style="width:260px;">
		  <?php echo JText::sprintf("URL");?>
		</th>
		</tr>
	   </table>
	 </div>
</td>
 
 
 </tr>
 </table>
  
</div>

<script type="text/javascript">
var zoomerPrevImageSkipMeasure = true;
jQuery('#zoomerEditorDialog button').button();
var zoomer_aspectRat = 1;
var zoomerPMDragArgs = null;
var zoomerPMResArgs = null;

//jQuery(function(){
  zoomer_aspectRat = parseFloat(jQuery('#jform_params_viewWidth').val()) / parseFloat(jQuery('#jform_params_viewHeight').val());
  jQuery('#zoomerUserEditTable INPUT,#zoomerUserEditTable SELECT').change(function(){onZoomerUserValueChange();});
  
  jQuery('#zoomerVisualMesureFrom > DIV, #zoomerVisualMesureTo > DIV').innerWidth( Math.round(30 * zoomer_aspectRat)).innerHeight(30);
  
  jQuery('#zoomerVisualMesureFrom, #zoomerVisualMesureTo').draggable({ containment: "parent",
				   drag: function(event, ui){
						var updEl = null; 
						if(jQuery(this).attr('id') == 'zoomerVisualMesureFrom')
						  updEl = jQuery('#k_from');
						else
						  updEl = jQuery('#k_to');
						var val = zoomerCalculatePreviewPos(this);
						updEl.val( String(val[0]) + "," + String(val[1]) + "," + String(val[2]) ); 
						jQuery("#zoomerEditorList .current").attr('k_from',jQuery('#k_from').val());
						jQuery("#zoomerEditorList .current").attr('k_to',jQuery('#k_to').val());
						
				   }
				  });
				  
  jQuery('#zoomerVisualMesureFrom > DIV:not(.ui-resizable), #zoomerVisualMesureTo > DIV:not(.ui-resizable)').resizable({
					containment: "#zoomerPerViewContainer",
					aspectRatio: zoomer_aspectRat,
					resize: function(event, ui) { 
					
								var updEl = null; 
								if(jQuery(this).parent().attr('id') == 'zoomerVisualMesureFrom')
								  updEl = jQuery('#k_from');
								else
								  updEl = jQuery('#k_to');
								var val = zoomerCalculatePreviewPos(jQuery(this).parent()[0]);
								updEl.val( String(val[0]) + "," + String(val[1]) + "," + String(val[2]) );
								jQuery("#zoomerEditorList .current").attr('k_from',jQuery('#k_from').val());
								jQuery("#zoomerEditorList .current").attr('k_to',jQuery('#k_to').val());
								
					}
				});
  
  
				
  
  
  jQuery('#zoomer_cmdAdd').click(function(){
    Zoomer_AddRow(null).click();
	jQuery('#zoomerVisualMesureFrom, #zoomerVisualMesureTo').each(function(){
	if(jQuery(this).parent().position().left)
	 {   jQuery(this).css({
		 left: String(jQuery(this).parent().position().left) + 'px',
		 top: String(jQuery(this).parent().position().top) + 'px'
		});
	 }	
	
	
    });	
    jQuery('#zoomerVisualMesureFrom > DIV, #zoomerVisualMesureTo > DIV').innerWidth( Math.round(30 * zoomer_aspectRat)).innerHeight(30);
  
  });
  jQuery('#zoomer_cmdRemove').click(function(){
    onZoomerDeleteItem();
	return false;
  });
  
  jQuery('#zoomer_cmdUP').click(function(){
    if(jQuery("#zoomerEditorList .current")[0]){
	  var curr = jQuery(jQuery("#zoomerEditorList .current")[0]);
	  var No = jQuery(curr.find('TD')[0]).html();
      var prev = curr.prev();
	  
	  if(prev[0]){
		if(prev.find("TH").length == 0){ 
			jQuery(curr.find('TD')[0]).html( jQuery(prev.find('TD')[0]).html() );
			jQuery(prev.find('TD')[0]).html(No);
			curr.insertBefore(prev);
		}
	  }
	  
	}
  });
  
  jQuery('#zoomer_cmdDown').click(function(){
    if(jQuery("#zoomerEditorList .current")[0]){
	  var curr = jQuery(jQuery("#zoomerEditorList .current")[0]);
	  var No = jQuery(curr.find('TD')[0]).html();
      var next = curr.next();
	  if(next[0]){
	    jQuery(curr.find('TD')[0]).html( jQuery(next.find('TD')[0]).html());
	    jQuery(next.find('TD')[0]).html(No);
		curr.insertAfter(next);
	  }
	}
  });
  
  jQuery('#k_src').click(function(){
    zoomerPrevImageSkipMeasure = false;
  }).mousedown(function(){
    zoomerPrevImageSkipMeasure = false;
  });

//});


function zoomerCalculatePreviewPos(el){
     var val    = [0,0,1];
	 var top    = jQuery(el).offset().top - jQuery(el).parent().offset().top - 1;
	 var left   = jQuery(el).offset().left - jQuery(el).parent().offset().left - 1;
	 var width  = jQuery(el).innerWidth();
	 var height = jQuery(el).innerHeight();
	 var pwidth  = jQuery(el).parent().innerWidth();
	 var pheight = jQuery(el).parent().innerHeight();
	 
	 if(!(pwidth  - width  == 0)) val[0] = Math.round((left / (pwidth  - width)) * 100)/100;else val[0] = 1;
	 if(!(pheight - height == 0)) val[1] = Math.round((top  / (pheight - height)) * 100)/100;else val[1] = 1;  
	 
	 var sc = width/pwidth;
	 if( height/pheight > sc) sc = height/pheight;
	 
	 
	 if(sc != 0)val[2] = Math.round((1/sc) * 100)/100;else val[2] = 1;
	 
	 return val;
}


function zoomerSetPreviewPos(val_f,val_t)
{
 
   var refW = true;
   var pwidth  = jQuery('#zoomerPerViewContainer').innerWidth();
   var pheight = jQuery('#zoomerPerViewContainer').innerHeight();
   var width; 
   var height; 
   var top;
   var left;
   
   if( pheight < pwidth) refW = false; 
   
 
  if(val_f){
    try{
	  if(refW){
	    width = pwidth/val_f[2] - 4;
		height = width * (1/zoomer_aspectRat) - 4;
	  }
	  else{
	    height = pheight/val_f[2] - 4;
		width = height * zoomer_aspectRat - 4 ;
	  }
	  
	  left = (pwidth  - width - 3) * val_f[0] + jQuery('#zoomerPerViewContainer').position().left + 1;
	  top  = (pheight - height - 4) * val_f[1] +  jQuery('#zoomerPerViewContainer').position().top + 1;
	  
	
	  
	  jQuery('#zoomerVisualMesureFromResizer').css({
	    width: String(width) + 'px',
		height: String(height) + 'px'
	  });
	  
	  jQuery('#zoomerVisualMesureFrom').css({
	    left: String(left) + 'px',
		top: String(top) + 'px'
	  });
	  
	  
	}catch(Exf){
	//
	}
  }
  
  
  if(val_t){
    try{
	  if(refW){
	    width = pwidth/val_t[2]  - 4;
		height = width * (1/zoomer_aspectRat) - 4;
	  }
	  else{
	    height = pheight/val_t[2] - 4;
		width = height * zoomer_aspectRat  - 4;
	  }
	  
	  left = (pwidth  - width - 3) * val_t[0] + jQuery('#zoomerPerViewContainer').position().left + 1;
	  top  = (pheight - height - 4) * val_t[1] +  jQuery('#zoomerPerViewContainer').position().top + 1;
	  
	  
	  
	  jQuery('#zoomerVisualMesureToResizer').css({
	    width: String(width) + 'px',
		height: String(height) + 'px'
	  });
	  
	  jQuery('#zoomerVisualMesureTo').css({
	    left: String(left) + 'px',
		top: String(top) + 'px'
	  });
	
	}catch(Ext){
	//
	}
  }

}

function ShowZoomerModal()
{
  jQuery("#zoomerNoLoadMessage").css({display:'block'});
  jQuery("#zoomerUserEditTable").css({display:'none'});

  
   
  
  
 zoomer_aspectRat = parseFloat(jQuery('#jform_params_viewWidth').val()) / parseFloat(jQuery('#jform_params_viewHeight').val());
 if(!zoomer_aspectRat)zoomer_aspectRat = 1;
 jQuery('#zoomerVisualMesureFrom > DIV, #zoomerVisualMesureTo > DIV').innerWidth( Math.round(30 * zoomer_aspectRat)).innerHeight(30);
 jQuery('#zoomerVisualMesureFrom .ui-resizable, #zoomerVisualMesureTo .ui-resizable').resizable( "option", "aspectRatio", zoomer_aspectRat );
 
 
 jQuery('#zoomerEditorDialog').dialog({
             bgiframe: true,
             autoOpen: false,
             modal: true,
             closeOnEscape: true,
             resizable: true,
             draggable: true,
             show: "blind",
             hide: "drop",
			 width: 740,
			// height: 600,
			 resizeStop: function(event, ui){
			   jQuery('#zoomerEditorListView').innerHeight(ui.size.height - 150);
			   jQuery('#zoomerEditorListView').innerWidth(ui.size.width - 390 );
			   jQuery('#zoomerEditorToolbar').innerWidth(ui.size.width - 390 );
			 },
			 title:"<?php echo JText::sprintf("HOT Joomla Zoomer - Edit Images For Zoomer Module");?>",
			 buttons: [
                            {
                                text: "<?php echo JText::sprintf("Ok");?>",
                                click: function () {
								  var Val = new Array();
								  jQuery('#zoomerEditorList tr').each(function(ind){
								    if(ind > 0){
									 if(jQuery(this).attr("k_src"))
									  Val[ind-1]=     {
									                 src: jQuery(this).attr("k_src"),
													 item_duration:	jQuery(this).attr("k_item_duration"),
													 animation_duration:	jQuery(this).attr("k_animation_duration"),
													 animationEasing:	jQuery(this).attr("k_animationEasing"),
													 from:	jQuery(this).attr("k_from").split(','),
													 to:	jQuery(this).attr("k_to").split(','),
													 title:	jQuery(this).attr("k_title"),
													 link:	jQuery(this).attr("k_link"),
													 width:	jQuery(this).attr("k_width"),
													 height:jQuery(this).attr("k_height")
									               };
									}
								  });
								  jQuery('#<?php echo $this->id; ?>').val(JSON.stringify(Val));
								  jQuery(this).dialog("close");
								}
							},
                            {
                                text: "<?php echo JText::sprintf("Cancel");?>",
                                click: function () {
								  jQuery(this).dialog("close");
								}
							},							
			         ],
             close: function (ev, ui) {
                 jQuery(this).dialog("destroy");
                 //jQuery(this).remove(); 
             }
  });
  LoadZoomerData(); 
  jQuery('#zoomerEditorDialog').dialog('open');
  return false;
}

function LoadZoomerData()
{
  var sVal = jQuery('#<?php echo $this->id; ?>').val();
  if(!sVal)sVal = "[]";
  var zoomerData = eval("(" + sVal + ")");
  
  while(jQuery("#zoomerEditorList").find("TR").length > 1){
   jQuery("#zoomerEditorList").find("TR").last().remove();
  } 
 
  if(zoomerData.length > 0){
      for(var i = 0 ; i < zoomerData.length ; i++){
	        Zoomer_AddRow(zoomerData[i]);
	  } 
	  
	  if(jQuery('#zoomerEditorList tr')[1]){
	    jQuery(jQuery('#zoomerEditorList tr')[1]).click();
	  }
  }
  return false;
}

function Zoomer_AddRow(item){
            if(!item) item = {}; 
		    var zoomer_row = jQuery("<tr><td>" + String(jQuery("#zoomerEditorList tr").length) + "</td><td>" + (item.src ? item.src : "") + "</td></tr>");
			jQuery("#zoomerEditorList").append(zoomer_row);
			zoomer_row.attr("k_src",(item.src ? item.src : ""));
			zoomer_row.attr("k_item_duration",(item.item_duration ? item.item_duration : "8000") );
			zoomer_row.attr("k_animation_duration",(item.animation_duration ? item.animation_duration : "4000") );
			zoomer_row.attr("k_animationEasing",(item.animationEasing ? item.animationEasing : 'linear'));
			zoomer_row.attr("k_from", (item.from ? (String(item.from[0]) + ',' + String(item.from[1]) + ',' + String(item.from[2])) : "0,0,1" ));
			zoomer_row.attr("k_to", (item.to ? (String(item.to[0]) + ',' + String(item.to[1]) + ',' + String(item.to[2])) : "1,1,1" ));
			zoomer_row.attr("k_title",(item.title ? item.title : "" ));
			zoomer_row.attr("k_link",(item.link ? item.link : ""));
			zoomer_row.attr("k_width",(item.width ? item.width : "0"));
			zoomer_row.attr("k_height",(item.height ? item.height : "0") );
			zoomer_row.click(function(){ onSelectZoomerListRow(this); });
			return zoomer_row;
}

function onSelectZoomerListRow(row){
  if(row.hasClass('current')) return false;
  zoomerPrevImageSkipMeasure = true;
  jQuery("#zoomerEditorList .current").removeClass('current').removeClass('ui-widget-header');
  row.addClass('current').addClass('ui-widget-header');
  
  jQuery("#zoomerNoLoadMessage").css({display:'none'});
  jQuery("#zoomerUserEditTable").css({display:'block'});
  
  ShowZoomerCurrent();
  
  return false;
}

function ShowZoomerCurrent(){
  
  jQuery('#zoomerUserEditTable INPUT,#zoomerUserEditTable SELECT').each(function(){
	   if(jQuery("#zoomerEditorList .current")[0]){
	     jQuery(this).val(jQuery("#zoomerEditorList .current").attr(jQuery(this).attr("id")));   
	   }else{
	     jQuery(this).val(null);
	   }
  });
 
  jQuery('#zoomerPreviewImage').attr('src', jQuery("#zoomerUserEditTable #k_src").val());
 
   /*     
  
  
 */
  
  
  return false;
}

function onZoomerUserValueChange(){
  jQuery('#zoomerUserEditTable INPUT,#zoomerUserEditTable SELECT').each(function(){
	   if(jQuery("#zoomerEditorList .current")[0]){
	     
		 
		 if(jQuery(this).attr("id") == "k_src"){
		    
			if(jQuery("#zoomerEditorList .current").attr(jQuery(this).attr("id")) != jQuery(this).val()){
			jQuery("#zoomerEditorList .current").attr(jQuery(this).attr("id"),jQuery(this).val());
				jQuery(jQuery("#zoomerEditorList .current").find("TD")[1]).html(jQuery(this).val());
				setzoomerPreviewImage(jQuery(this).val());
			}
		 }else{
		    jQuery("#zoomerEditorList .current").attr(jQuery(this).attr("id"),jQuery(this).val());
		 }
		 
		 if(jQuery(this).attr("id") == "k_from" || jQuery(this).attr("id") == "k_to"){
		   zoomerSetPreviewPos(jQuery("#k_from").val().split(','),jQuery("#k_to").val().split(','));
		 }
	   }
  });
  return false;
}

function setzoomerPreviewImage(src){
  
 if(!zoomerPrevImageSkipMeasure){  
  jQuery('#zoomerPreviewImage').removeAttr('width');
  jQuery('#zoomerPreviewImage').removeAttr('height');
  jQuery('#zoomerPreviewImage').parent().css({overflow:'hidden'});
 }
 
 jQuery('#zoomerPreviewImage').attr('src',src);
  
  return false;
}

function zoomerImageMeasure(){
   if(!zoomerPrevImageSkipMeasure){
	   var w = jQuery('#zoomerPreviewImage').innerWidth();
	   var h = jQuery('#zoomerPreviewImage').innerHeight();
	   jQuery('#k_width').val(w);
	   jQuery('#k_height').val(h);
	   jQuery("#zoomerEditorList .current").attr('k_width',w);
	   jQuery("#zoomerEditorList .current").attr('k_height',h);
	  
	  jQuery('#zoomerPreviewImage').parent().css({overflow:'auto'});
	  jQuery('#zoomerPreviewImage').attr('width' , '300px');
	  jQuery('#zoomerPreviewImage').parent().css({width:'300px'});
	  jQuery('#zoomerPreviewImage').attr('height', String((h/w)*300) + 'px');
	  zoomerPrevImageSkipMeasure = true;
  }
  zoomerSetPreviewPos(jQuery("#k_from").val().split(','),jQuery("#k_to").val().split(','));
  return false;
}

function onZoomerDeleteItem(){
   if(jQuery("#zoomerEditorList .current")[0]){
     var No   = parseInt( jQuery("#zoomerEditorList .current td").html());
	 var Next = jQuery("#zoomerEditorList .current").next();
	 while(Next[0]){
	   jQuery(Next.find("TD")[0]).html(No);
	   No++;
	   Next = Next.next();
	 }
	 jQuery("#zoomerEditorList .current").remove();
   }else alert("<?php echo JText::sprintf("First Select Item For Removal!");?>");
   return false;
}


</script>
	
		<?php
		//----------------------------------------------
        $OUT = ob_get_contents();
        ob_end_clean();		
        return $OUT; 
		
	}
}
